"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = exports.EDITOR_MODE = void 0;
var _react = _interopRequireDefault(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/json_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDITOR_MODE = exports.EDITOR_MODE = {
  TEXT: 'text',
  JSON: 'json'
};
const JsonEditor = ({
  value,
  height = '300px',
  // 99% width allows the editor to resize horizontally. 100% prevents it from resizing.
  width = '99%',
  mode = EDITOR_MODE.JSON,
  readOnly = false,
  onChange = () => {},
  transparentBackground = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: value,
    width: width,
    height: height,
    languageId: mode,
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    isCopyable: true,
    options: {
      tabSize: 2,
      readOnly,
      automaticLayout: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      quickSuggestions: true
    },
    onChange: onChange,
    transparentBackground: transparentBackground,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
};
exports.JsonEditor = JsonEditor;