"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountChartWithBrush = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _i18n = require("@kbn/i18n");
var _aiopsComponents = require("@kbn/aiops-components");
var _i18nReact = require("@kbn/i18n-react");
var _single_brush = require("./single_brush");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/document_count_chart_single_brush/document_count_chart_singular.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// TODO Consolidate with similar component `DocumentCountChartWithBrush` in
// x-pack/packages/private/ml/aiops_components/src/document_count_chart/document_count_chart.tsx

/**
 * Brush settings
 */

/**
 * Callback function which gets called when the brush selection has changed
 *
 * @param windowParameters Brush selection time ranges.
 * @param force Force update
 */

/**
 * Props for document count chart
 */

const SPEC_ID = 'document_count';
var VIEW_MODE = /*#__PURE__*/function (VIEW_MODE) {
  VIEW_MODE["ZOOM"] = "zoom";
  VIEW_MODE["BRUSH"] = "brush";
  return VIEW_MODE;
}(VIEW_MODE || {});
/**
 * Document count chart with draggable brushes to select time ranges
 * by default use `Baseline` and `Deviation` for the badge names
 *
 * @param props DocumentCountChart component props
 * @returns The DocumentCountChart component.
 */
const DocumentCountChartWithBrush = props => {
  var _window$_echDebugStat;
  const {
    id,
    dataTestSubj,
    dependencies,
    brushSelectionUpdateHandler,
    width,
    height,
    chartPoints,
    chartPointsSplit,
    timeRangeEarliest,
    timeRangeLatest,
    interval,
    chartPointsSplitLabel,
    isBrushCleared,
    autoAnalysisStart,
    barColorOverride,
    barStyleAccessor,
    barHighlightColorOverride,
    brush = {}
  } = props;
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = dependencies;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const xAxisFormatter = fieldFormats.deserialize({
    id: 'date'
  });
  const overallSeriesName = _i18n.i18n.translate('xpack.dataVisualizer.dataDriftt.seriesLabel', {
    defaultMessage: 'document count'
  });
  const overallSeriesNameWithSplit = _i18n.i18n.translate('xpack.dataVisualizer.dataDrifttSplit.seriesLabel', {
    defaultMessage: 'Other document count'
  });

  // TODO Let user choose between ZOOM and BRUSH mode.
  const [viewMode] = (0, _react.useState)(VIEW_MODE.BRUSH);
  const hasNoData = (0, _react.useMemo)(() => (chartPoints === undefined || chartPoints.length < 1) && (chartPointsSplit === undefined || Array.isArray(chartPointsSplit) && chartPointsSplit.length < 1), [chartPoints, chartPointsSplit]);
  const adjustedChartPoints = (0, _react.useMemo)(() => {
    // Display empty chart when no data in range and no split data to show
    if (hasNoData) return [{
      time: timeRangeEarliest,
      value: 0
    }];

    // If chart has only one bucket
    // it won't show up correctly unless we add an extra data point
    if (chartPoints.length === 1) {
      return [...chartPoints, {
        time: interval ? Number(chartPoints[0].time) + interval : timeRangeEarliest,
        value: 0
      }];
    }
    return chartPoints;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartPoints, timeRangeEarliest, timeRangeLatest, interval]);
  const adjustedChartPointsSplit = (0, _react.useMemo)(() => {
    // Display empty chart when no data in range
    if (hasNoData) return [{
      time: timeRangeEarliest,
      value: 0
    }];

    // If chart has only one bucket
    // it won't show up correctly unless we add an extra data point
    if (Array.isArray(chartPointsSplit) && chartPointsSplit.length === 1) {
      return [...chartPointsSplit, {
        time: interval ? Number(chartPointsSplit[0].time) + interval : timeRangeEarliest,
        value: 0
      }];
    }
    return chartPointsSplit;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartPointsSplit, timeRangeEarliest, timeRangeLatest, interval]);
  const snapTimestamps = (0, _react.useMemo)(() => {
    const timestamps = [];
    let n = timeRangeEarliest;
    while (n <= timeRangeLatest + interval) {
      timestamps.push(n);
      n += interval;
    }
    return timestamps;
  }, [timeRangeEarliest, timeRangeLatest, interval]);
  const timefilterUpdateHandler = (0, _react.useCallback)(range => {
    data.query.timefilter.timefilter.setTime({
      from: (0, _moment.default)(range.from).toISOString(),
      to: (0, _moment.default)(range.to).toISOString(),
      mode: 'absolute'
    });
  }, [data]);
  const onBrushEnd = ({
    x
  }) => {
    if (!x) {
      return;
    }
    const [from, to] = x;
    timefilterUpdateHandler({
      from,
      to
    });
  };
  const timeZone = (0, _visualizationUtils.getTimeZone)(uiSettings);
  const [originalWindowParameters, setOriginalWindowParameters] = (0, _react.useState)();
  const [windowParameters, setWindowParameters] = (0, _react.useState)();
  const triggerAnalysis = (0, _react.useCallback)(startRange => {
    if (viewMode === VIEW_MODE.ZOOM && typeof startRange === 'number') {
      const range = {
        from: startRange,
        to: startRange + interval
      };
      timefilterUpdateHandler(range);
    } else if (viewMode === VIEW_MODE.BRUSH) {
      if (originalWindowParameters === undefined && windowParameters === undefined && adjustedChartPoints !== undefined) {
        const wp = typeof startRange === 'number' ? (0, _single_brush.getSingleBrushWindowParameters)(startRange + interval / 2, timeRangeEarliest, timeRangeLatest + interval) : startRange;
        const wpSnap = (0, _single_brush.getSnappedSingleBrushWindowParameters)(wp, snapTimestamps);
        setOriginalWindowParameters(wpSnap);
        setWindowParameters(wpSnap);
        if (brushSelectionUpdateHandler !== undefined) {
          brushSelectionUpdateHandler(wpSnap, true);
        }
      }
    }
  }, [interval, timeRangeEarliest, timeRangeLatest, snapTimestamps, originalWindowParameters, setWindowParameters, brushSelectionUpdateHandler, adjustedChartPoints, timefilterUpdateHandler, viewMode, windowParameters]);
  const onElementClick = (0, _react.useCallback)(([elementData]) => {
    if (brushSelectionUpdateHandler === undefined) {
      return;
    }
    const startRange = elementData[0].x;
    triggerAnalysis(startRange);
  }, [triggerAnalysis, brushSelectionUpdateHandler]);
  (0, _react.useEffect)(() => {
    if (autoAnalysisStart !== undefined) {
      triggerAnalysis(autoAnalysisStart);
    }
  }, [triggerAnalysis, autoAnalysisStart]);
  (0, _react.useEffect)(() => {
    if (isBrushCleared && originalWindowParameters !== undefined) {
      setOriginalWindowParameters(undefined);
      setWindowParameters(undefined);
    }
  }, [isBrushCleared, originalWindowParameters]);
  function onWindowParametersChange(wp) {
    if (brushSelectionUpdateHandler === undefined) {
      return;
    }
    setWindowParameters(wp);
    brushSelectionUpdateHandler(wp, false);
  }
  const [mlBrushWidth, setMlBrushWidth] = (0, _react.useState)();
  const [mlBrushMarginLeft, setMlBrushMarginLeft] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (viewMode !== VIEW_MODE.BRUSH) {
      setOriginalWindowParameters(undefined);
      setWindowParameters(undefined);
    }
  }, [viewMode]);
  const isBrushVisible = originalWindowParameters && windowParameters && mlBrushMarginLeft && mlBrushWidth && mlBrushWidth > 0;
  const barColor = barColorOverride ? [barColorOverride] : euiTheme.colors.vis.euiColorVis0;
  const barHighlightColor = barHighlightColorOverride ? [barHighlightColorOverride] : ['orange'];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isBrushVisible ? /*#__PURE__*/_react.default.createElement("div", {
    className: "dataDriftSingleBrush",
    "data-test-subj": `dataDriftSingleBrush-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      marginBottom: '-4px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_single_brush.SingleBrush, {
    id: id,
    windowParameters: originalWindowParameters,
    min: timeRangeEarliest,
    max: timeRangeLatest + interval,
    onChange: onWindowParametersChange,
    marginLeft: mlBrushMarginLeft,
    snapTimestamps: snapTimestamps,
    width: mlBrushWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataDrift.dataDriftDocumentCountChart.clickToSelectTimeRangeLabel",
    defaultMessage: "Click on a bucket in the chart to select a time range for {id} data",
    values: {
      id
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: width !== null && width !== void 0 ? width : '100%'
    },
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'dataDriftDocumentCountChart',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: '100%',
      height: height !== null && height !== void 0 ? height : 120
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: viewMode !== VIEW_MODE.BRUSH ? onBrushEnd : undefined,
    onElementClick: onElementClick,
    onProjectionAreaChange: ({
      projection
    }) => {
      setMlBrushMarginLeft(projection.left);
      setMlBrushWidth(projection.width);
    },
    baseTheme: chartBaseTheme,
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    showLegend: false,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: `data-drift-histogram-left-axis-${id}`,
    position: _charts.Position.Left,
    ticks: 2,
    integersOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: `data-drift-histogram-bottom-axis-${id}`,
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: value => xAxisFormatter.convert(value),
    labelFormat: () => '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 11
    }
  }), (adjustedChartPoints === null || adjustedChartPoints === void 0 ? void 0 : adjustedChartPoints.length) && /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: SPEC_ID,
    name: chartPointsSplit ? overallSeriesNameWithSplit : overallSeriesName
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "time",
    yAccessors: ['value'],
    stackAccessors: ['true'],
    data: adjustedChartPoints,
    timeZone: timeZone,
    color: barColor,
    yNice: true,
    styleAccessor: barStyleAccessor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 13
    }
  }), (adjustedChartPointsSplit === null || adjustedChartPointsSplit === void 0 ? void 0 : adjustedChartPointsSplit.length) && /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: `${SPEC_ID}_split`,
    name: chartPointsSplitLabel
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "time",
    yAccessors: ['value'],
    stackAccessors: ['true'],
    data: adjustedChartPointsSplit,
    timeZone: timeZone,
    color: barHighlightColor,
    yNice: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 13
    }
  }), windowParameters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_aiopsComponents.DualBrushAnnotation, {
    id: "data-drift-annotation",
    min: windowParameters.min,
    max: windowParameters.max,
    style: brush.annotationStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 482,
      columnNumber: 15
    }
  })))));
};
exports.DocumentCountChartWithBrush = DocumentCountChartWithBrush;