"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityDetailsRoute = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kbn_url_state_context = require("../../utils/kbn_url_state_context");
var _use_kibana = require("../../utils/use_kibana");
var _context = require("./context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/data_quality/public/routes/dataset_quality_details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasetQualityDetailsRoute = () => {
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  const {
    services: {
      datasetQuality,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return /*#__PURE__*/_react.default.createElement(_context.DatasetQualityDetailsContextProvider, {
    datasetQuality: datasetQuality,
    urlStateStorageContainer: urlStateStorageContainer,
    toastsService: notifications.toasts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ConnectedContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }));
};
exports.DatasetQualityDetailsRoute = DatasetQualityDetailsRoute;
const ConnectedContent = /*#__PURE__*/_react.default.memo(() => {
  const {
    controller
  } = (0, _context.useDatasetQualityDetailsContext)();
  return controller ? /*#__PURE__*/_react.default.createElement(InitializedContent, {
    datasetQualityDetailsController: controller,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
      logo: "logoKibana",
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 15
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataQuality.details.Initializing",
      defaultMessage: "Initializing Data set quality details page",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }));
});
const InitializedContent = /*#__PURE__*/_react.default.memo(({
  datasetQualityDetailsController
}) => {
  const {
    services: {
      datasetQuality
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return /*#__PURE__*/_react.default.createElement(datasetQuality.DatasetQualityDetails, {
    controller: datasetQualityDetailsController,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 12
    }
  });
});