"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SearchSessionIndicator = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _custom_icons = require("./custom_icons");
var _components = require("./components");
var _search_session_state = require("../../search_session_state");
var _search_sessions_deprecation_message = require("../../search_sessions_deprecation_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/session_indicator/search_session_indicator/search_session_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CancelButton = ({
  onCancel = () => {},
  buttonProps = {}
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  onClick: onCancel,
  "data-test-subj": 'searchSessionIndicatorCancelBtn',
  color: "danger"
}, buttonProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 3
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.cancelButtonText",
  defaultMessage: "Stop session",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 5
  }
}));
const ContinueInBackgroundButton = ({
  onContinueInBackground = () => {},
  buttonProps = {},
  saveDisabled = false,
  saveDisabledReasonText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: saveDisabledReasonText,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  onClick: onContinueInBackground,
  "data-test-subj": 'searchSessionIndicatorSaveBtn',
  isDisabled: saveDisabled
}, buttonProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.continueInBackgroundButtonText",
  defaultMessage: "Save session",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 7
  }
})));
const ViewAllSearchSessionsButton = ({
  viewSearchSessionsLink = 'management/kibana/search_sessions',
  onViewSearchSessions = () => {},
  buttonProps = {},
  managementDisabled,
  managementDisabledReasonText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: managementDisabledReasonText,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 100,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  href: viewSearchSessionsLink,
  onClick: onViewSearchSessions,
  "data-test-subj": 'searchSessionIndicatorViewSearchSessionsLink',
  isDisabled: managementDisabled
}, buttonProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.viewSearchSessionsLinkText",
  defaultMessage: "Manage sessions",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 109,
    columnNumber: 7
  }
})));
const SaveButton = ({
  onSaveResults = () => {},
  buttonProps = {},
  saveDisabled = false,
  saveDisabledReasonText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: saveDisabledReasonText,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 123,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
  onClick: onSaveResults,
  "data-test-subj": 'searchSessionIndicatorSaveBtn',
  isDisabled: saveDisabled
}, buttonProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 124,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "data.searchSessionIndicator.saveButtonText",
  defaultMessage: "Save session",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 130,
    columnNumber: 7
  }
})));
const searchSessionIndicatorViewStateToProps = ({
  state
}) => {
  const stateProps = {
    [_search_session_state.SearchSessionState.None]: null,
    [_search_session_state.SearchSessionState.Loading]: {
      button: {
        color: 'text',
        iconType: _custom_icons.PartialClock,
        'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchLoadingResultsIconAriaLabel', {
          defaultMessage: 'Background search loading'
        }),
        tooltipText: _i18n.i18n.translate('data.backgroundSearchIndicator.backgroundSearchLoadingResultsIconTooltipText', {
          defaultMessage: 'Background search loading'
        })
      },
      popover: {
        title: _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsTitle', {
          defaultMessage: 'Your search is taking a while...'
        }),
        description: _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsDescription', {
          defaultMessage: 'Save your session, continue your work, and return to completed results'
        }),
        whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.loadingResultsWhenText', {
          defaultMessage: 'Started {when}',
          values: {
            when: props.startedTime ? (0, _moment.default)(props.startedTime).format(`L @ LTS`) : ''
          }
        }),
        primaryAction: CancelButton,
        secondaryAction: ContinueInBackgroundButton
      }
    },
    [_search_session_state.SearchSessionState.Completed]: {
      button: {
        color: 'text',
        iconType: 'check',
        'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchResultsLoadedIconAriaLabel', {
          defaultMessage: 'Background search complete'
        }),
        tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchResultsLoadedIconTooltipText', {
          defaultMessage: 'Background search complete'
        })
      },
      popover: {
        title: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchResultsLoadedText', {
          defaultMessage: 'Background search complete'
        }),
        description: _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedDescriptionText', {
          defaultMessage: 'Save your session and return to it later'
        }),
        whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.resultsLoadedWhenText', {
          defaultMessage: 'Completed {when}',
          values: {
            when: props.completedTime ? (0, _moment.default)(props.completedTime).format(`L @ LTS`) : ''
          }
        }),
        primaryAction: SaveButton,
        secondaryAction: ViewAllSearchSessionsButton
      }
    },
    [_search_session_state.SearchSessionState.BackgroundLoading]: {
      button: {
        iconType: _eui.EuiLoadingSpinner,
        'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchLoadingInTheBackgroundIconAriaLabel', {
          defaultMessage: 'Background search in progress'
        }),
        tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchLoadingInTheBackgroundIconTooltipText', {
          defaultMessage: 'Background search in progress'
        })
      },
      popover: {
        title: _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundTitleText', {
          defaultMessage: 'Background search in progress'
        }),
        description: _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundDescriptionText', {
          defaultMessage: 'You can return to completed results from Management'
        }),
        whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.loadingInTheBackgroundWhenText', {
          defaultMessage: 'Started {when}',
          values: {
            when: props.startedTime ? (0, _moment.default)(props.startedTime).format(`L @ LTS`) : ''
          }
        }),
        primaryAction: CancelButton,
        secondaryAction: ViewAllSearchSessionsButton
      }
    },
    [_search_session_state.SearchSessionState.BackgroundCompleted]: {
      button: {
        color: 'success',
        iconType: 'checkInCircleFilled',
        'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundIconAriaLabel', {
          defaultMessage: 'Background search complete'
        }),
        tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundIconTooltipText', {
          defaultMessage: 'Background search complete'
        })
      },
      popover: {
        title: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchResultLoadedInTheBackgroundTitleText', {
          defaultMessage: 'Background search saved'
        }),
        description: _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundDescriptionText', {
          defaultMessage: 'You can return to these results from Management'
        }),
        whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.resultLoadedInTheBackgroundWhenText', {
          defaultMessage: 'Completed {when}',
          values: {
            when: props.completedTime ? (0, _moment.default)(props.completedTime).format(`L @ LTS`) : ''
          }
        }),
        secondaryAction: ViewAllSearchSessionsButton
      }
    },
    [_search_session_state.SearchSessionState.Restored]: {
      button: {
        color: 'success',
        iconType: _custom_icons.CheckInEmptyCircle,
        'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchRestoredResultsIconAriaLabel', {
          defaultMessage: 'Background search restored'
        }),
        tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchRestoredResultsTooltipText', {
          defaultMessage: 'Background search restored'
        })
      },
      popover: {
        title: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchRestoredTitleText', {
          defaultMessage: 'Background search restored'
        }),
        description: _i18n.i18n.translate('data.searchSessionIndicator.restoredDescriptionText', {
          defaultMessage: 'You are viewing cached data from a specific time range. Changing the time range or filters will re-run the session'
        }),
        whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.restoredWhenText', {
          defaultMessage: 'Completed {when}',
          values: {
            when: props.completedTime ? (0, _moment.default)(props.completedTime).format(`L @ LTS`) : ''
          }
        }),
        secondaryAction: ViewAllSearchSessionsButton
      }
    },
    [_search_session_state.SearchSessionState.Canceled]: {
      button: {
        color: 'danger',
        iconType: 'error',
        'aria-label': _i18n.i18n.translate('data.searchSessionIndicator.canceledIconAriaLabel', {
          defaultMessage: 'Background search stopped'
        }),
        tooltipText: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchCanceledTooltipText', {
          defaultMessage: 'Background search stopped'
        })
      },
      popover: {
        title: _i18n.i18n.translate('data.searchSessionIndicator.backgroundSearchCanceledTitleText', {
          defaultMessage: 'Background search stopped'
        }),
        description: _i18n.i18n.translate('data.searchSessionIndicator.canceledDescriptionText', {
          defaultMessage: 'You are viewing incomplete data'
        }),
        whenText: props => _i18n.i18n.translate('data.searchSessionIndicator.canceledWhenText', {
          defaultMessage: 'Stopped {when}',
          values: {
            when: props.canceledTime ? (0, _moment.default)(props.canceledTime).format(`L @ LTS`) : ''
          }
        }),
        secondaryAction: ViewAllSearchSessionsButton
      }
    }
  };
  return stateProps[state];
};
const SearchSessionIndicator = exports.SearchSessionIndicator = /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  var _props$saveDisabled, _popover$whenText;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onOpened = props.onOpened;
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
    if (onOpened) onOpened(props.state);
  }, [onOpened, props.state]);
  const onButtonClick = (0, _react.useCallback)(() => {
    if (isPopoverOpen) {
      closePopover();
    } else {
      openPopover();
    }
  }, [isPopoverOpen, openPopover, closePopover]);
  (0, _react.useImperativeHandle)(ref, () => ({
    openPopover: () => {
      openPopover();
    },
    closePopover: () => {
      closePopover();
    }
  }), [openPopover, closePopover]);
  const stateProps = searchSessionIndicatorViewStateToProps({
    state: props.state
  });
  if (!stateProps) return null;
  const {
    button,
    popover
  } = stateProps;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: 'downLeft',
    panelPaddingSize: 'm',
    css: styles.popover,
    "data-test-subj": 'searchSessionIndicator',
    "data-state": props.state,
    "data-save-disabled": (_props$saveDisabled = props.saveDisabled) !== null && _props$saveDisabled !== void 0 ? _props$saveDisabled : false,
    panelProps: {
      css: styles.panel
    },
    repositionOnScroll: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: button.tooltipText,
      delay: 'long',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: button.color,
      "aria-label": button['aria-label'],
      iconType: button.iconType,
      onClick: onButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 437,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "searchSessionIndicatorPopoverContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_sessions_deprecation_message.SearchSessionsDeprecatedWarning, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 447,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 9
    }
  }), props.searchSessionName && props.saveSearchSessionNameFn ? /*#__PURE__*/_react.default.createElement(_components.SearchSessionName, {
    name: props.searchSessionName,
    editName: props.saveSearchSessionNameFn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 13
    }
  }, popover.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 9
    }
  }), (_popover$whenText = popover.whenText) !== null && _popover$whenText !== void 0 && _popover$whenText.call(popover, props) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 15
    }
  }, popover.whenText(props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 472,
      columnNumber: 11
    }
  }, popover.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 474,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    alignItems: 'center',
    justifyContent: 'flexEnd',
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 9
    }
  }, popover.primaryAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 483,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(popover.primaryAction, (0, _extends2.default)({}, props, {
    buttonProps: {
      size: 'xs'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 484,
      columnNumber: 15
    }
  }))), popover.secondaryAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(popover.secondaryAction, (0, _extends2.default)({}, props, {
    buttonProps: {
      size: 'xs',
      flush: 'right'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 489,
      columnNumber: 15
    }
  }))))));
});

// React.lazy() needs default:
// eslint-disable-next-line import/no-default-export
var _default = exports.default = SearchSessionIndicator;
const componentStyles = {
  popover: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: `0 ${euiTheme.size.xs}`
  }),
  panel: ({
    euiTheme
  }) => (0, _react2.css)({
    width: `calc(${euiTheme.size.base} * 18)`
  })
};