"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservedItem = exports.Item = exports.DashboardGridItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = _interopRequireWildcard(require("react"));
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _use_dashboard_internal_api = require("../../dashboard_api/use_dashboard_internal_api");
var _kibana_services = require("../../services/kibana_services");
var _print_styles = require("../print_styles");
var _constants = require("./constants");
var _highlight_styles = require("./highlight_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/grid/dashboard_grid_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Item = exports.Item = /*#__PURE__*/_react2.default.forwardRef(({
  appFixedViewport,
  id,
  index,
  type,
  isRenderable = true,
  setDragHandles,
  children,
  className,
  ...rest
}, ref) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const dashboardInternalApi = (0, _use_dashboard_internal_api.useDashboardInternalApi)();
  const [highlightPanelId, scrollToPanelId, expandedPanelId, focusedPanelId, useMargins, viewMode, dashboardContainerRef] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.highlightPanelId$, dashboardApi.scrollToPanelId$, dashboardApi.expandedPanelId$, dashboardApi.focusedPanelId$, dashboardApi.settings.useMargins$, dashboardApi.viewMode$, dashboardInternalApi.dashboardContainerRef$);
  const expandPanel = expandedPanelId !== undefined && expandedPanelId === id;
  const hidePanel = expandedPanelId !== undefined && expandedPanelId !== id;
  const focusPanel = focusedPanelId !== undefined && focusedPanelId === id;
  const blurPanel = focusedPanelId !== undefined && focusedPanelId !== id;
  const classes = (0, _classnames.default)('dshDashboardGrid__item', {
    'dshDashboardGrid__item--expanded': expandPanel,
    'dshDashboardGrid__item--hidden': hidePanel,
    'dshDashboardGrid__item--focused': focusPanel,
    'dshDashboardGrid__item--blurred': blurPanel,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    printViewport__vis: viewMode === 'print'
  });
  (0, _react2.useLayoutEffect)(() => {
    if (typeof ref !== 'function' && ref !== null && ref !== void 0 && ref.current) {
      const panelRef = ref.current;
      if (scrollToPanelId === id) {
        dashboardApi.scrollToPanel(panelRef);
      }
      if (highlightPanelId === id) {
        dashboardApi.highlightPanel(panelRef);
      }
      panelRef.querySelectorAll('*').forEach(e => {
        if (blurPanel) {
          // remove blurred panels and nested elements from tab order
          e.setAttribute('tabindex', '-1');
        } else {
          // restore tab order
          e.removeAttribute('tabindex');
        }
      });
    }
  }, [id, dashboardApi, scrollToPanelId, highlightPanelId, ref, blurPanel]);
  const dashboardContainerTopOffset = (dashboardContainerRef === null || dashboardContainerRef === void 0 ? void 0 : dashboardContainerRef.offsetTop) || 0;
  const globalNavTopOffset = (appFixedViewport === null || appFixedViewport === void 0 ? void 0 : appFixedViewport.offsetTop) || 0;
  const styles = (0, _use_memo_css.useMemoCss)(dashboardGridItemStyles);
  const renderedEmbeddable = (0, _react2.useMemo)(() => {
    const panelProps = {
      showBadges: true,
      showBorder: useMargins,
      showNotifications: true,
      showShadow: false,
      setDragHandles
    };
    return /*#__PURE__*/_react2.default.createElement(_public.EmbeddableRenderer, {
      type: type,
      maybeId: id,
      getParentApi: () => ({
        ...dashboardApi,
        reload$: dashboardInternalApi.panelsReload$
      }),
      key: `${type}_${id}`,
      panelProps: panelProps,
      onApiAvailable: api => dashboardInternalApi.registerChildApi(api),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    });
  }, [id, dashboardApi, dashboardInternalApi, type, useMargins, setDragHandles]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hoverActionsHeight = euiTheme.base * 2;
  const focusStyles = blurPanel ? styles.focusPanelBlur : (0, _react.css)({
    scrollMarginTop: `${dashboardContainerTopOffset + globalNavTopOffset + _constants.DASHBOARD_MARGIN_SIZE + hoverActionsHeight}px`
  });
  return /*#__PURE__*/_react2.default.createElement("div", (0, _extends2.default)({
    css: [focusStyles, styles.item],
    className: [classes, className].join(' '),
    "data-test-subj": "dashboardPanel",
    id: `panel-${id}`,
    ref: ref
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), isRenderable ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, renderedEmbeddable, children) : /*#__PURE__*/_react2.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  })));
});
const ObservedItem = exports.ObservedItem = /*#__PURE__*/_react2.default.forwardRef((props, panelRef) => {
  const [intersection, updateIntersection] = (0, _react2.useState)();
  const [isRenderable, setIsRenderable] = (0, _react2.useState)(false);
  const observerRef = (0, _react2.useRef)(new window.IntersectionObserver(([value]) => updateIntersection(value), {
    root: panelRef.current
  }));
  (0, _react2.useEffect)(() => {
    const {
      current: currentObserver
    } = observerRef;
    currentObserver.disconnect();
    const {
      current
    } = panelRef;
    if (current) {
      currentObserver.observe(current);
    }
    return () => currentObserver.disconnect();
  }, [panelRef]);
  (0, _react2.useEffect)(() => {
    if (intersection !== null && intersection !== void 0 && intersection.isIntersecting && !isRenderable) {
      setIsRenderable(true);
    }
  }, [intersection, isRenderable]);
  return /*#__PURE__*/_react2.default.createElement(Item, (0, _extends2.default)({
    ref: panelRef,
    isRenderable: isRenderable
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 10
    }
  }));
});
const DashboardGridItem = exports.DashboardGridItem = /*#__PURE__*/_react2.default.forwardRef((props, ref) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const viewMode = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.viewMode$);
  const deferBelowFoldEnabled = (0, _react2.useMemo)(() => _kibana_services.presentationUtilService.labsService.isProjectEnabled('labs:dashboard:deferBelowFold'), []);
  const isEnabled = viewMode !== 'print' && deferBelowFoldEnabled;
  return isEnabled ? /*#__PURE__*/_react2.default.createElement(ObservedItem, (0, _extends2.default)({
    ref: ref
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 22
    }
  })) : /*#__PURE__*/_react2.default.createElement(Item, (0, _extends2.default)({
    ref: ref
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 62
    }
  }));
});
const dashboardGridItemStyles = {
  item: context => (0, _react.css)([{
    height: '100%',
    // Remove padding in fullscreen mode
    '.kbnAppWrapper--hiddenChrome &.dshDashboardGrid__item--expanded': {
      padding: 0
    },
    '.kbnAppWrapper--hiddenChrome & .dshDashboardGrid__item--expanded': {
      padding: 0
    }
  }, (0, _highlight_styles.getHighlightStyles)(context), (0, _print_styles.printViewportVisStyles)(context)]),
  focusPanelBlur: (0, _react.css)({
    pointerEvents: 'none',
    opacity: '0.25'
  })
};