"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityIdContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _test_subjects = require("../test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_id_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_VALUE = '-';
const VulnerabilityIdContent = ({
  vulnerability
}) => {
  const [showAllReferences, setShowAllReferences] = (0, _react.useState)(false);
  if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.id) || vulnerability.id.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": _test_subjects.VULNERABILITY_EMPTY_VALUE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 12
      }
    }, EMPTY_VALUE);
  }
  const sortReferencesByName = () => {
    // Handle case where either reference or id is not an array
    const ids = Array.isArray(vulnerability.id) ? vulnerability.id : [vulnerability.id];
    const references = Array.isArray(vulnerability.reference) ? vulnerability.reference : [vulnerability.reference];
    return ids.map(id => {
      const referenceLink = (0, _cloudSecurityPosture.findReferenceLink)(references, id);
      return {
        id,
        link: referenceLink !== null && referenceLink !== void 0 ? referenceLink : ''
      };
    });
  };
  const sortedReferences = sortReferencesByName();
  const MAX_VISIBLE_ITEMS = 4;
  const hasMoreItems = sortedReferences.length > MAX_VISIBLE_ITEMS;
  const visibleReferences = showAllReferences ? sortedReferences : sortedReferences.slice(0, MAX_VISIBLE_ITEMS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    css: (0, _react2.css)`
        max-height: 200px;
        overflow-y: auto;
        flex-wrap: wrap;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, visibleReferences.map(({
    id,
    link
  }, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${id}-${index}`,
    grow: false,
    css: {
      flexShrink: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, link ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "primary",
    css: {
      display: 'flex'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": (0, _test_subjects.getVulnerabilityLinkTestId)(id),
    href: link,
    target: "_blank",
    css: (0, _react2.css)`
                  display: inline-flex;
                  align-items: center;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }, id), index !== visibleReferences.length - 1 && ',') : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": (0, _test_subjects.getVulnerabilityIdTestId)(id),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, index === visibleReferences.length - 1 ? id : `${id},`))), !showAllReferences && hasMoreItems && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, "...")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": _test_subjects.VULNERABILITY_OVERVIEW_TAB_ID_MORE_BTN,
    color: "primary",
    size: "xs",
    onClick: () => setShowAllReferences(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.showMore",
    defaultMessage: "Show more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })))), showAllReferences && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": _test_subjects.VULNERABILITY_OVERVIEW_TAB_ID_LESS_BTN,
    color: "primary",
    size: "xs",
    onClick: () => setShowAllReferences(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.showLess",
    defaultMessage: "Show less",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }))));
};
exports.VulnerabilityIdContent = VulnerabilityIdContent;