"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _kibana = require("../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/visualizations/lens_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LENS_VISUALIZATION_HEIGHT = 200;
const LensRendererComponent = ({
  attributes,
  timeRange,
  metadata
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!attributes) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metadata && metadata.description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, metadata.description, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          min-height: ${LENS_VISUALIZATION_HEIGHT}px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "",
    style: {
      height: LENS_VISUALIZATION_HEIGHT
    },
    timeRange: timeRange,
    attributes: attributes,
    renderMode: "view",
    disableTriggers: true,
    executionContext: {
      type: 'cases'
    },
    syncTooltips: false,
    syncCursor: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: (0, _react2.css)`
            div.euiOverlayMask[data-relative-to-header='above'] ~ [id^='echTooltipPortal'] {
              z-index: ${euiTheme.levels.modal} !important;
            }
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  })));
};
LensRendererComponent.displayName = 'LensRenderer';
const LensRenderer = exports.LensRenderer = /*#__PURE__*/_react.default.memo(LensRendererComponent);