"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createActionAttachmentUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _timestamp = require("../timestamp");
var _copy_link = require("../copy_link");
var _markdown_editor = require("../../markdown_editor");
var _host_isolation_event = require("./host_isolation_event");
var _hoverable_user_with_avatar_resolver = require("../../user_profiles/hoverable_user_with_avatar_resolver");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/comment/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createActionAttachmentUserActionBuilder = ({
  userAction,
  userProfiles,
  attachment,
  actionsNavigation
}) => ({
  build: () => {
    const actionIconName = attachment.actions.type === 'isolate' ? 'lock' : 'lockOpen';
    return [{
      username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
        user: attachment.createdBy,
        userProfiles: userProfiles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 11
        }
      }),
      className: (0, _classnames.default)('comment-action', {
        'empty-comment': attachment.comment.trim().length === 0
      }),
      event: /*#__PURE__*/_react.default.createElement(_host_isolation_event.HostIsolationCommentEvent, {
        type: attachment.actions.type,
        endpoints: attachment.actions.targets,
        href: actionsNavigation === null || actionsNavigation === void 0 ? void 0 : actionsNavigation.href,
        onClick: actionsNavigation === null || actionsNavigation === void 0 ? void 0 : actionsNavigation.onClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }),
      'data-test-subj': 'endpoint-action',
      timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
        createdAt: userAction.createdAt,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 20
        }
      }),
      timelineAvatar: actionIconName,
      timelineAvatarAriaLabel: actionIconName,
      actions: /*#__PURE__*/_react.default.createElement(_copy_link.UserActionCopyLink, {
        id: attachment.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 18
        }
      }),
      children: attachment.comment.trim().length > 0 && /*#__PURE__*/_react.default.createElement(_markdown_editor.ScrollableMarkdown, {
        content: attachment.comment,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      })
    }];
  }
});
exports.createActionAttachmentUserActionBuilder = createActionAttachmentUserActionBuilder;