"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateCaseNavigation = exports.useConfigureCasesNavigation = exports.useCasesNavigation = exports.useCaseViewParams = exports.useCaseViewNavigation = exports.useAllCasesNavigation = void 0;
exports.useUrlParams = useUrlParams;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
var _kibana = require("../lib/kibana");
var _paths = require("./paths");
var _utils = require("../../components/utils");
var _use_application = require("../lib/kibana/use_application");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCaseViewParams = () => (0, _reactRouterDom.useParams)();
exports.useCaseViewParams = useCaseViewParams;
function useUrlParams() {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const [urlParams, setUrlParams] = (0, _react.useState)(() => (0, _utils.parseURL)(search));
  const toUrlParams = (0, _react.useCallback)((params = urlParams) => (0, _utils.stringifyToURL)(params), [urlParams]);
  (0, _react.useEffect)(() => {
    setUrlParams((0, _utils.parseURL)(search));
  }, [search]);
  return {
    urlParams,
    toUrlParams
  };
}
const useCasesNavigation = ({
  path,
  deepLinkId
}) => {
  const {
    appId
  } = (0, _use_application.useApplication)();
  const {
    navigateTo,
    getAppUrl
  } = (0, _kibana.useNavigation)(appId);
  const getCasesUrl = (0, _react.useCallback)(absolute => getAppUrl({
    path,
    deepLinkId,
    absolute
  }), [getAppUrl, deepLinkId, path]);
  const navigateToCases = (0, _react.useCallback)(() => navigateTo({
    path,
    deepLinkId
  }), [navigateTo, deepLinkId, path]);
  return [getCasesUrl, navigateToCases];
};

/**
 * Cases can be either be part of a solution or a standalone application
 * The standalone application is registered from the cases plugin and is called
 * the main application. The main application uses paths and the solutions
 * deep links.
 */
exports.useCasesNavigation = useCasesNavigation;
const navigationMapping = {
  all: {
    path: '/'
  },
  create: {
    path: _constants.CASES_CREATE_PATH
  },
  configure: {
    path: _constants.CASES_CONFIGURE_PATH
  }
};
const useAllCasesNavigation = () => {
  const [getAllCasesUrl, navigateToAllCases] = useCasesNavigation({
    path: navigationMapping.all.path,
    deepLinkId: _constants.APP_ID
  });
  return {
    getAllCasesUrl,
    navigateToAllCases
  };
};
exports.useAllCasesNavigation = useAllCasesNavigation;
const useCreateCaseNavigation = () => {
  const [getCreateCaseUrl, navigateToCreateCase] = useCasesNavigation({
    path: navigationMapping.create.path,
    deepLinkId: _constants.APP_ID
  });
  return {
    getCreateCaseUrl,
    navigateToCreateCase
  };
};
exports.useCreateCaseNavigation = useCreateCaseNavigation;
const useConfigureCasesNavigation = () => {
  const [getConfigureCasesUrl, navigateToConfigureCases] = useCasesNavigation({
    path: navigationMapping.configure.path,
    deepLinkId: _constants.APP_ID
  });
  return {
    getConfigureCasesUrl,
    navigateToConfigureCases
  };
};
exports.useConfigureCasesNavigation = useConfigureCasesNavigation;
const useCaseViewNavigation = () => {
  const {
    appId
  } = (0, _use_application.useApplication)();
  const {
    navigateTo,
    getAppUrl
  } = (0, _kibana.useNavigation)(appId);
  const deepLinkId = _constants.APP_ID;
  const getCaseViewUrl = (0, _react.useCallback)((pathParams, absolute) => getAppUrl({
    deepLinkId,
    absolute,
    path: (0, _paths.generateCaseViewPath)(pathParams)
  }), [deepLinkId, getAppUrl]);
  const navigateToCaseView = (0, _react.useCallback)(pathParams => navigateTo({
    deepLinkId,
    path: (0, _paths.generateCaseViewPath)(pathParams)
  }), [navigateTo, deepLinkId]);
  return {
    getCaseViewUrl,
    navigateToCaseView
  };
};
exports.useCaseViewNavigation = useCaseViewNavigation;