"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/format_select/format_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FormatSelect extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isCustomFormat: !this.props.formatOptions.map(({
        value
      }) => value).includes(this.props.argValue)
    });
    (0, _defineProperty2.default)(this, "_options", this.props.formatOptions.concat({
      value: 'custom',
      text: 'Custom'
    }));
    (0, _defineProperty2.default)(this, "_handleTextChange", ev => this.props.onValueChange(ev.target.value));
    (0, _defineProperty2.default)(this, "_handleSelectChange", ev => {
      const {
        onValueChange,
        defaultCustomFormat
      } = this.props;
      const {
        value
      } = this._options[ev.target.selectedIndex];
      if (value === 'custom') {
        this.setState({
          isCustomFormat: true
        });
        return onValueChange(defaultCustomFormat);
      }
      if (this.state.isCustomFormat) {
        this.setState({
          isCustomFormat: false
        });
      }
      return onValueChange(value);
    });
  }
  render() {
    const {
      argId,
      argValue,
      defaultCustomFormat
    } = this.props;
    const {
      isCustomFormat
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      compressed: true,
      id: argId,
      value: isCustomFormat ? 'custom' : argValue,
      options: this._options,
      "aria-label": _i18n.i18n.translate('xpack.canvas.formatSelect.select.ariaLabel', {
        defaultMessage: 'Format options'
      }),
      onChange: this._handleSelectChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }), isCustomFormat && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: defaultCustomFormat,
      value: argValue,
      compressed: true,
      onChange: this._handleTextChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    })));
  }
}
exports.FormatSelect = FormatSelect;
(0, _defineProperty2.default)(FormatSelect, "propTypes", {
  argId: _propTypes.default.string,
  argValue: _propTypes.default.string,
  formatOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.string,
    text: _propTypes.default.string
  })).isRequired,
  onValueChange: _propTypes.default.func
});