"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMServiceContext = void 0;
exports.ApmServiceContextProvider = ApmServiceContextProvider;
exports.getOrRedirectToTransactionType = getOrRedirectToTransactionType;
exports.getTransactionType = getTransactionType;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _document_type = require("../../../common/document_type");
var _transaction_types = require("../../../common/transaction_types");
var _use_service_transaction_types_fetcher = require("./use_service_transaction_types_fetcher");
var _use_service_agent_fetcher = require("./use_service_agent_fetcher");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_time_range = require("../../hooks/use_time_range");
var _use_fallback_to_transactions_fetcher = require("../../hooks/use_fallback_to_transactions_fetcher");
var _url_helpers = require("../../components/shared/links/url_helpers");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_preferred_data_source_and_bucket_size = require("../../hooks/use_preferred_data_source_and_bucket_size");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/apm_service/apm_service_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const APMServiceContext = exports.APMServiceContext = /*#__PURE__*/(0, _react.createContext)({
  serviceName: '',
  transactionTypeStatus: _use_fetcher.FETCH_STATUS.NOT_INITIATED,
  transactionTypes: [],
  fallbackToTransactions: false,
  serviceAgentStatus: _use_fetcher.FETCH_STATUS.NOT_INITIATED,
  indexSettings: [],
  indexSettingsStatus: _use_fetcher.FETCH_STATUS.NOT_INITIATED
});
function ApmServiceContextProvider({
  children
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    path: {
      serviceName
    },
    query,
    query: {
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    agentName,
    runtimeName,
    serverlessType,
    telemetrySdkName,
    telemetrySdkLanguage,
    status: serviceAgentStatus
  } = (0, _use_service_agent_fetcher.useServiceAgentFetcher)({
    serviceName,
    start,
    end
  });
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    type: _document_type.ApmDocumentType.TransactionMetric,
    numBuckets: 100
  });
  const {
    transactionTypes,
    status: transactionTypeStatus
  } = (0, _use_service_transaction_types_fetcher.useServiceTransactionTypesFetcher)({
    serviceName,
    start,
    end,
    documentType: preferred === null || preferred === void 0 ? void 0 : preferred.source.documentType,
    rollupInterval: preferred === null || preferred === void 0 ? void 0 : preferred.source.rollupInterval
  });
  const currentTransactionType = getOrRedirectToTransactionType({
    transactionType: query.transactionType,
    transactionTypes,
    agentName,
    history
  });
  const {
    fallbackToTransactions
  } = (0, _use_fallback_to_transactions_fetcher.useFallbackToTransactionsFetcher)({
    kuery
  });
  const {
    data = {
      apmIndexSettings: []
    },
    status: indexSettingsStatus
  } = (0, _use_fetcher.useFetcher)((_, signal) => services.apmSourcesAccess.getApmIndexSettings({
    signal
  }), [services.apmSourcesAccess]);
  return /*#__PURE__*/_react.default.createElement(APMServiceContext.Provider, {
    value: {
      serviceName,
      agentName,
      serverlessType,
      telemetrySdkName,
      telemetrySdkLanguage,
      transactionType: currentTransactionType,
      transactionTypeStatus,
      transactionTypes,
      runtimeName,
      fallbackToTransactions,
      serviceAgentStatus,
      indexSettings: data === null || data === void 0 ? void 0 : data.apmIndexSettings,
      indexSettingsStatus
    },
    children: children,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
}
const isTypeExistsInTransactionTypesList = ({
  transactionType,
  transactionTypes
}) => !!transactionType && transactionTypes.includes(transactionType);
const isNoAgentAndNoTransactionTypes = ({
  transactionTypes,
  agentName
}) => !agentName || transactionTypes.length === 0;
function getTransactionType({
  transactionType,
  transactionTypes,
  agentName
}) {
  const isTransactionTypeExists = isTypeExistsInTransactionTypesList({
    transactionType,
    transactionTypes
  });
  if (isTransactionTypeExists) return transactionType;
  const isNoAgentAndNoTransactionTypesExists = isNoAgentAndNoTransactionTypes({
    transactionTypes,
    agentName
  });
  if (isNoAgentAndNoTransactionTypesExists) return undefined;
  const defaultTransactionType = (0, _transaction_types.getDefaultTransactionType)(agentName);

  // If the default transaction type is not in transactionTypes the first in the list is returned
  const currentTransactionType = transactionTypes.includes(defaultTransactionType) ? defaultTransactionType : transactionTypes[0];
  return currentTransactionType;
}
function getOrRedirectToTransactionType({
  transactionType,
  transactionTypes,
  agentName,
  history
}) {
  const isTransactionTypeExists = isTypeExistsInTransactionTypesList({
    transactionType,
    transactionTypes
  });
  if (isTransactionTypeExists) return transactionType;
  const isNoAgentAndNoTransactionTypesExists = isNoAgentAndNoTransactionTypes({
    transactionTypes,
    agentName
  });
  if (isNoAgentAndNoTransactionTypesExists) return undefined;
  const currentTransactionType = getTransactionType({
    transactionTypes,
    transactionType,
    agentName
  });

  // Replace transactionType in the URL in case it is not one of the types returned by the API
  (0, _url_helpers.replace)(history, {
    query: {
      transactionType: currentTransactionType
    }
  });
  return currentTransactionType;
}