"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KueryBar = KueryBar;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _esQuery = require("@kbn/es-query");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_adhoc_apm_data_view = require("../../../hooks/use_adhoc_apm_data_view");
var _url_helpers = require("../links/url_helpers");
var _get_bool_filter = require("../get_bool_filter");
var _typeahead = require("./typeahead");
var _use_processor_event = require("../../../hooks/use_processor_event");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/kuery_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function convertKueryToEsQuery(kuery, dataView) {
  const ast = (0, _esQuery.fromKueryExpression)(kuery);
  return (0, _esQuery.toElasticsearchQuery)(ast, dataView);
}
function KueryBar(props) {
  var _props$placeholder;
  const {
    path,
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const serviceName = 'serviceName' in path ? path.serviceName : undefined;
  const groupId = 'groupId' in path ? path.groupId : undefined;
  const environment = 'environment' in query ? query.environment : undefined;
  const _kuery = 'kuery' in query ? query.kuery : undefined;
  const kuery = props.value || _kuery;
  const history = (0, _reactRouterDom.useHistory)();
  const [state, setState] = (0, _react.useState)({
    suggestions: [],
    isLoadingSuggestions: false
  });
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    unifiedSearch
  } = (0, _use_apm_plugin_context.useApmPluginContext)().plugins;
  let currentRequestCheck;
  const processorEvent = (0, _use_processor_event.useProcessorEvent)();
  const examples = {
    transaction: 'transaction.duration.us > 300000',
    error: 'http.response.status_code >= 400',
    metric: 'process.pid = "1234"',
    defaults: 'transaction.duration.us > 300000 AND http.response.status_code >= 400'
  };
  const example = examples[processorEvent || 'defaults'];
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const placeholder = (_props$placeholder = props.placeholder) !== null && _props$placeholder !== void 0 ? _props$placeholder : _i18n.i18n.translate('xpack.apm.kueryBar.placeholder', {
    defaultMessage: `Search {event, select,
            transaction {transactions}
            metric {metrics}
            error {errors}
            other {transactions, errors, and metrics}
          } (e.g. {queryExample})`,
    values: {
      queryExample: example,
      event: processorEvent
    }
  });
  async function onChange(inputValue, selectionStart) {
    if (typeof props.onChange === 'function') {
      props.onChange(inputValue);
    }
    if (dataView == null) {
      return;
    }
    setState({
      ...state,
      suggestions: [],
      isLoadingSuggestions: true
    });
    const currentRequest = (0, _lodash.uniqueId)();
    currentRequestCheck = currentRequest;
    try {
      var _props$boolFilter;
      const suggestions = (await unifiedSearch.autocomplete.getQuerySuggestions({
        language: 'kuery',
        indexPatterns: [dataView],
        boolFilter: (_props$boolFilter = props.boolFilter) !== null && _props$boolFilter !== void 0 ? _props$boolFilter : (0, _get_bool_filter.getBoolFilter)({
          groupId,
          processorEvent,
          serviceName,
          environment,
          urlParams
        }),
        query: inputValue,
        selectionStart,
        selectionEnd: selectionStart,
        useTimeRange: true,
        method: 'terms_agg'
      })) || [];
      const filteredSuggestions = props.suggestionFilter ? suggestions.filter(props.suggestionFilter) : suggestions;
      if (currentRequest !== currentRequestCheck) {
        return;
      }
      setState({
        ...state,
        suggestions: filteredSuggestions.slice(0, 15),
        isLoadingSuggestions: false
      });
    } catch (e) {
      console.error('Error while fetching suggestions', e);
    }
  }
  function onSubmit(inputValue) {
    if (dataView == null) {
      return;
    }
    try {
      const res = convertKueryToEsQuery(inputValue, dataView);
      if (!res) {
        return;
      }
      if (props.onSubmit) {
        props.onSubmit(inputValue.trim());
        return;
      }
      history.push({
        ...location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _url_helpers.toQuery)(location.search),
          kuery: inputValue.trim()
        })
      });
    } catch (e) {
      console.log('Invalid kuery syntax'); // eslint-disable-line no-console
    }
  }
  return /*#__PURE__*/_react.default.createElement(_typeahead.Typeahead, {
    isLoading: state.isLoadingSuggestions,
    initialValue: kuery,
    onChange: onChange,
    onSubmit: onSubmit,
    suggestions: state.suggestions,
    placeholder: placeholder,
    prepend: props.prepend,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  });
}