"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorageChart = StorageChart;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _viz_colors = require("../../../../common/viz_colors");
var _use_progressive_fetcher = require("../../../hooks/use_progressive_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _chart_container = require("../../shared/charts/chart_container");
var _timezone = require("../../shared/charts/helper/timezone");
var _helper = require("../../shared/charts/helper/helper");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _formatters = require("../../../../common/utils/formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/storage_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StorageChart() {
  var _data$storageTimeSeri, _data$storageTimeSeri2;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const chartThemes = (0, _public.useChartThemes)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiPaletteColorBlindRotations = 3;
  const groupedPalette = (0, _eui.euiPaletteColorBlind)({
    rotations: euiPaletteColorBlindRotations
  });
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      indexLifecyclePhase
    }
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_progressive_fetcher.useProgressiveFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/storage_chart', {
      params: {
        query: {
          indexLifecyclePhase,
          environment,
          kuery,
          start,
          end
        }
      }
    });
  }, [indexLifecyclePhase, environment, kuery, start, end]);
  const storageTimeSeries = (_data$storageTimeSeri = data === null || data === void 0 ? void 0 : (_data$storageTimeSeri2 = data.storageTimeSeries) === null || _data$storageTimeSeri2 === void 0 ? void 0 : _data$storageTimeSeri2.map(({
    timeseries,
    serviceName
  }, index) => {
    return {
      data: timeseries !== null && timeseries !== void 0 ? timeseries : [],
      type: 'area',
      color: groupedPalette[Math.floor(index % (10 * euiPaletteColorBlindRotations))],
      title: serviceName
    };
  })) !== null && _data$storageTimeSeri !== void 0 ? _data$storageTimeSeri : [];
  const xValues = storageTimeSeries.flatMap(({
    data: timeseriesData
  }) => timeseriesData.map(({
    x
  }) => x));
  const min = Math.min(...xValues);
  const max = Math.max(...xValues);
  const xFormatter = (0, _charts.niceTimeFormatter)([min, max]);
  const timeZone = (0, _timezone.getTimeZone)(core.uiSettings);
  const isEmpty = (0, _helper.isTimeseriesEmpty)(storageTimeSeries);
  return /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: !isEmpty,
    height: 400,
    status: status,
    id: "storageExplorerTimeseriesChart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    id: "storageExplorerTimeseriesChart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [{
      areaSeriesStyle: {
        line: {
          visible: false
        },
        area: {
          opacity: 1
        }
      }
    }, ...chartThemes.theme],
    baseTheme: chartThemes.baseTheme,
    showLegend: true,
    legendPosition: _charts.Position.Right,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: xFormatter,
    gridLine: {
      visible: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    tickFormat: _formatters.asDynamicBytes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }), storageTimeSeries.map((serie, index) => /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    timeZone: timeZone,
    key: serie.title,
    id: serie.title,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    data: isEmpty ? [] : serie.data,
    color: (0, _viz_colors.getVizColorForIndex)(index, euiTheme),
    stackAccessors: ['x'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }))));
}