"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingHostsTopNFunctions = ProfilingHostsTopNFunctions;
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../../common/es_fields/apm");
var _kuery_utils = require("../../../../common/utils/kuery_utils");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _top_functions_link = require("../../shared/profiling/top_functions/top_functions_link");
var _filter_warning = require("./filter_warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/profiling_overview/profiling_hosts_top_functions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ProfilingHostsTopNFunctions({
  serviceName,
  start,
  end,
  environment,
  startIndex,
  endIndex,
  dataSource,
  kuery,
  rangeFrom,
  rangeTo
}) {
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (dataSource) {
      return callApmApi('GET /internal/apm/services/{serviceName}/profiling/hosts/functions', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end,
            environment,
            startIndex,
            endIndex,
            documentType: dataSource.documentType,
            rollupInterval: dataSource.rollupInterval,
            kuery
          }
        }
      });
    }
  }, [dataSource, serviceName, start, end, environment, startIndex, endIndex, kuery]);
  const profilingKueryFilter = data !== null && data !== void 0 && data.containerIds && data.containerIds.length > 0 ? (0, _kuery_utils.toKueryFilterFormat)(_apm.CONTAINER_ID, (data === null || data === void 0 ? void 0 : data.containerIds) || []) : (0, _kuery_utils.toKueryFilterFormat)(_apm.HOST_NAME, (data === null || data === void 0 ? void 0 : data.hostNames) || []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_warning.FilterWarning, {
    containerIds: data === null || data === void 0 ? void 0 : data.containerIds,
    hostNames: data === null || data === void 0 ? void 0 : data.hostNames,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_top_functions_link.ProfilingTopNFunctionsLink, {
    kuery: (0, _kuery_utils.mergeKueries)([`(${profilingKueryFilter})`, kuery]),
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.EmbeddableFunctions, {
    data: data === null || data === void 0 ? void 0 : data.functions,
    isLoading: (0, _use_fetcher.isPending)(status),
    rangeFrom: new Date(start).valueOf(),
    rangeTo: new Date(end).valueOf(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
}