"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = EmptyPrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _no_results_dark = _interopRequireDefault(require("../../../../assets/no_results_dark.svg"));
var _no_results_light = _interopRequireDefault(require("../../../../assets/no_results_light.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/infra_overview/infra_tabs/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmptyPrompt() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessagePromptTimeRangeTitle', {
      defaultMessage: 'Expand your time range'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessagePromptDescription', {
      defaultMessage: 'Try searching over a longer period of time.'
    }))),
    color: "subdued",
    "data-test-subj": "metricsTableEmptyIndicesContent",
    icon: /*#__PURE__*/_react.default.createElement(NoResultsIllustration, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessagePromptTitle', {
      defaultMessage: 'No results match your search criteria.'
    })),
    titleSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}
function NoResultsIllustration() {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const illustration = colorMode === 'DARK' ? _no_results_dark.default : _no_results_light.default;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: noResultsIllustrationAlternativeText,
    size: "fullWidth",
    src: illustration,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
}
const noResultsIllustrationAlternativeText = _i18n.i18n.translate('xpack.apm.infraTabs.emptyMessageIllustrationAlternativeText', {
  defaultMessage: 'A magnifying glass with an exclamation mark'
});