"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformOperations = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformOperations = ({
  operations,
  isSystemAction
}) => {
  if (operations == null || operations.length === 0) {
    return [];
  }
  return operations.map(operation => {
    if (operation.field !== 'actions') {
      return operation;
    }
    const actions = operation.value.map(action => {
      var _action$group;
      if (isSystemAction(action.id)) {
        return {
          id: action.id,
          params: action.params,
          uuid: action.uuid
        };
      }
      return {
        id: action.id,
        group: (_action$group = action.group) !== null && _action$group !== void 0 ? _action$group : 'default',
        params: action.params,
        uuid: action.uuid,
        frequency: action.frequency
      };
    });
    return {
      field: operation.field,
      operation: operation.operation,
      value: actions
    };
  });
};
exports.transformOperations = transformOperations;