"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCopyToClipboardAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _table_action_button = require("./table_action_button");
var _get_table_item_as_kql = require("./get_table_item_as_kql");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis_results_table/use_copy_to_clipboard_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const copyToClipboardButtonLabel = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.linksMenu.copyToClipboardButtonLabel', {
  defaultMessage: 'Copy to clipboard'
});
const copyToClipboardSignificantItemMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.linksMenu.copyToClipboardSignificantItemMessage', {
  defaultMessage: 'Copy field/value pair as KQL syntax to clipboard'
});
const copyToClipboardGroupMessage = _i18n.i18n.translate('xpack.aiops.logRateAnalysis.resultsTable.linksMenu.copyToClipboardGroupMessage', {
  defaultMessage: 'Copy group items as KQL syntax to clipboard'
});
const useCopyToClipboardAction = () => ({
  render: tableItem => {
    const message = (0, _mlAggUtils.isSignificantItem)(tableItem) ? copyToClipboardSignificantItemMessage : copyToClipboardGroupMessage;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: (0, _get_table_item_as_kql.getTableItemAsKQL)(tableItem),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_table_action_button.TableActionButton, {
      dataTestSubjPostfix: "CopyToClipboard",
      iconType: "copyClipboard",
      isDisabled: false,
      label: copyToClipboardButtonLabel,
      onClick: copy,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    })));
  }
});
exports.useCopyToClipboardAction = useCopyToClipboardAction;