"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MiniChartPreview = exports.ChangePointsTable = void 0;
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlInMemoryTable = require("@kbn/ml-in-memory-table");
var _react = _interopRequireWildcard(require("react"));
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _change_point_detection_context = require("./change_point_detection_context");
var _no_data_warning = require("./no_data_warning");
var _use_common_chart_props = require("./use_common_chart_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/change_points_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getFilterConfig(index, item, negate) {
  return {
    meta: {
      disabled: false,
      negate,
      alias: null,
      index,
      key: `${item.group.name}_${item.group.value}`,
      // @ts-ignore FilterMeta type definition misses the field property
      field: item.group.name,
      params: {
        query: item.group.value
      },
      type: 'phrase'
    },
    query: {
      match_phrase: {
        [item.group.name]: item.group.value
      }
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    }
  };
}
const pageSizeOptions = [5, 10, 15];
const ChangePointsTable = ({
  isLoading,
  annotations,
  fieldConfig,
  onSelectionChange,
  onRenderComplete
}) => {
  const {
    fieldFormats,
    data: {
      query: {
        filterManager
      }
    },
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();
  const chartLoadingCount = (0, _react.useRef)(0);
  const {
    onTableChange,
    pagination,
    sorting
  } = (0, _mlInMemoryTable.useTableState)(annotations !== null && annotations !== void 0 ? annotations : [], 'p_value', 'asc', {
    pageIndex: 0,
    pageSize: 10,
    pageSizeOptions
  });
  const dateFormatter = (0, _react.useMemo)(() => fieldFormats.deserialize({
    id: 'date'
  }), [fieldFormats]);
  (0, _react.useEffect)(() => {
    // Reset loading counter on pagination or sort change
    chartLoadingCount.current = 0;
  }, [pagination.pageIndex, pagination.pageSize, sorting.sort]);

  /**
   * Callback to track render of each chart component
   * to report when all charts on the current page are ready.
   */
  const onChartRenderCompleteCallback = (0, _react.useCallback)(isLoadingChart => {
    if (!onRenderComplete) return;
    if (!isLoadingChart) {
      chartLoadingCount.current++;
    }
    if (chartLoadingCount.current === pagination.pageSize) {
      onRenderComplete();
    }
  }, [onRenderComplete, pagination.pageSize]);
  const hasActions = fieldConfig.splitField !== undefined && embeddingOrigin !== 'cases';
  const {
    bucketInterval
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const columns = [{
    id: 'timestamp',
    field: 'timestamp',
    'data-test-subj': 'aiopsChangePointTimestamp',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.timeColumn', {
      defaultMessage: 'Time'
    }),
    sortable: true,
    truncateText: false,
    width: '230px',
    render: timestamp => dateFormatter.convert(timestamp)
  }, {
    id: 'preview',
    'data-test-subj': 'aiopsChangePointPreview',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.previewColumn', {
      defaultMessage: 'Preview'
    }),
    align: 'center',
    width: '200px',
    height: '80px',
    truncateText: false,
    valign: 'middle',
    css: {
      '.euiTableCellContent': {
        display: 'block',
        padding: 0
      }
    },
    render: annotation => {
      return /*#__PURE__*/_react.default.createElement(MiniChartPreview, {
        annotation: annotation,
        fieldConfig: fieldConfig,
        interval: bucketInterval.expression,
        onRenderComplete: onChartRenderCompleteCallback.bind(null, false),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 11
        }
      });
    }
  }, {
    id: 'type',
    'data-test-subj': 'aiopsChangePointType',
    field: 'type',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.typeColumn', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    truncateText: false,
    render: type => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 56
      }
    }, type)
  }, {
    id: 'pValue',
    'data-test-subj': 'aiopsChangePointPValue',
    field: 'p_value',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.pValueColumn', {
      defaultMessage: 'p-value'
    }),
    nameTooltip: {
      content: _i18n.i18n.translate('xpack.aiops.changePointDetection.pValueTooltip', {
        defaultMessage: 'Indicates how extreme the change is. Lower values indicate greater change.'
      })
    },
    sortable: true,
    truncateText: false,
    render: pValue => pValue !== undefined ? pValue.toPrecision(3) : '-'
  }, ...(fieldConfig.splitField ? [{
    id: 'groupName',
    'data-test-subj': 'aiopsChangePointGroupName',
    field: 'group.name',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.fieldNameColumn', {
      defaultMessage: 'Field name'
    }),
    truncateText: false
  }, {
    id: 'groupValue',
    'data-test-subj': 'aiopsChangePointGroupValue',
    field: 'group.value',
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.fieldValueColumn', {
      defaultMessage: 'Field value'
    }),
    truncateText: false,
    sortable: true
  }, ...(hasActions ? [{
    name: _i18n.i18n.translate('xpack.aiops.changePointDetection.actionsColumn', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterForValueAction', {
        defaultMessage: 'Filter for value'
      }),
      description: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterForValueAction', {
        defaultMessage: 'Filter for value'
      }),
      icon: 'plusInCircle',
      color: 'primary',
      type: 'icon',
      onClick: item => {
        filterManager.addFilters(getFilterConfig(dataView.id, item, false));
      },
      isPrimary: true,
      'data-test-subj': 'aiopsChangePointFilterForValue'
    }, {
      name: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterOutValueAction', {
        defaultMessage: 'Filter out value'
      }),
      description: _i18n.i18n.translate('xpack.aiops.changePointDetection.actions.filterOutValueAction', {
        defaultMessage: 'Filter out value'
      }),
      icon: 'minusInCircle',
      color: 'primary',
      type: 'icon',
      onClick: item => {
        filterManager.addFilters(getFilterConfig(dataView.id, item, true));
      },
      isPrimary: true,
      'data-test-subj': 'aiopsChangePointFilterOutValue'
    }]
  }] : [])] : [])];
  const selectionValue = (0, _react.useMemo)(() => {
    if (!onSelectionChange) return;
    return {
      selectable: item => true,
      onSelectionChange: selection => {
        onSelectionChange(selection.map(s => {
          return {
            ...s,
            ...fieldConfig
          };
        }));
      }
    };
  }, [fieldConfig, onSelectionChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    selection: selectionValue,
    loading: isLoading,
    "data-test-subj": `aiopsChangePointResultsTable ${isLoading ? 'loading' : 'loaded'}`,
    items: annotations,
    columns: columns,
    pagination: pagination.pageSizeOptions[0] > pagination.totalItemCount ? undefined : pagination,
    sorting: sorting,
    onTableChange: onTableChange,
    rowProps: item => ({
      'data-test-subj': `aiopsChangePointResultsTableRow row-${item.id}`
    }),
    message: isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "search",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 326,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.changePointDetection.fetchingChangePointsTitle",
        defaultMessage: "Fetching change points...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 327,
          columnNumber: 17
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_no_data_warning.NoDataFoundWarning, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 5
    }
  });
};
exports.ChangePointsTable = ChangePointsTable;
const MiniChartPreview = ({
  fieldConfig,
  annotation,
  onRenderComplete,
  onLoading
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    bucketInterval
  } = (0, _change_point_detection_context.useChangePointDetectionContext)();
  const {
    filters,
    query,
    attributes,
    timeRange
  } = (0, _use_common_chart_props.useCommonChartProps)({
    annotation,
    fieldConfig,
    previewMode: true,
    bucketInterval: bucketInterval.expression
  });
  const chartWrapperRef = (0, _react.useRef)(null);
  const renderCompleteListener = (0, _react.useCallback)(event => {
    if (event.target === chartWrapperRef.current) return;
    if (onRenderComplete) {
      onRenderComplete();
    }
  }, [onRenderComplete]);
  (0, _react.useEffect)(() => {
    if (!chartWrapperRef.current) {
      throw new Error('Reference to the chart wrapper is not set');
    }
    const chartWrapper = chartWrapperRef.current;
    chartWrapper.addEventListener('renderComplete', renderCompleteListener);
    return () => {
      chartWrapper.removeEventListener('renderComplete', renderCompleteListener);
    };
  }, [renderCompleteListener]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'aiopChangePointPreviewChart',
    ref: chartWrapperRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: `mini_changePointChart_${annotation.group ? annotation.group.value : annotation.label}`,
    style: {
      height: 80
    },
    timeRange: timeRange,
    noPadding: true,
    query: query,
    filters: filters
    // @ts-ignore
    ,
    attributes: attributes,
    renderMode: 'preview',
    executionContext: {
      type: 'aiops_change_point_detection_chart',
      name: 'Change point detection'
    },
    onLoad: onLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 7
    }
  }));
};
exports.MiniChartPreview = MiniChartPreview;