"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActivationsService = void 0;
const chain_1 = require("../../common/calculations/chain");
const OneToManyMapStar_1 = require("../../common/models/OneToManyMapStar");
var ActivationRelationKind;
(function (ActivationRelationKind) {
    ActivationRelationKind["moduleId"] = "moduleId";
    ActivationRelationKind["serviceId"] = "serviceId";
})(ActivationRelationKind || (ActivationRelationKind = {}));
class ActivationsService {
    #activationMaps;
    #getParent;
    constructor(getParent, activationMaps) {
        this.#activationMaps =
            activationMaps ??
                new OneToManyMapStar_1.OneToManyMapStar({
                    moduleId: {
                        isOptional: true,
                    },
                    serviceId: {
                        isOptional: false,
                    },
                });
        this.#getParent = getParent;
    }
    static build(getParent) {
        return new ActivationsService(getParent);
    }
    add(activation, relation) {
        this.#activationMaps.add(activation, relation);
    }
    clone() {
        const clone = new ActivationsService(this.#getParent, this.#activationMaps.clone());
        return clone;
    }
    get(serviceIdentifier) {
        const activationIterables = [];
        const activations = this.#activationMaps.get(ActivationRelationKind.serviceId, serviceIdentifier);
        if (activations !== undefined) {
            activationIterables.push(activations);
        }
        const parentActivations = this.#getParent()?.get(serviceIdentifier);
        if (parentActivations !== undefined) {
            activationIterables.push(parentActivations);
        }
        if (activationIterables.length === 0) {
            return undefined;
        }
        return (0, chain_1.chain)(...activationIterables);
    }
    removeAllByModuleId(moduleId) {
        this.#activationMaps.removeByRelation(ActivationRelationKind.moduleId, moduleId);
    }
    removeAllByServiceId(serviceId) {
        this.#activationMaps.removeByRelation(ActivationRelationKind.serviceId, serviceId);
    }
}
exports.ActivationsService = ActivationsService;
//# sourceMappingURL=ActivationsService.js.map