"use strict";

var _react = _interopRequireDefault(require("react"));
var _button = require("../button");
var _empty_prompt = require("./empty_prompt");
var _link = require("../link");
var _title = require("../title");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

beforeEach(function () {
  var addCaseSpy = cy.spy().as('addCaseSpy');
  var addLinkSpy = cy.spy().as('addLinkSpy');
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(_empty_prompt.EuiEmptyPrompt, {
    iconType: "logoSecurity",
    title: (0, _react2.jsx)("h2", null, "Start adding cases"),
    body: (0, _react2.jsx)("p", null, "Add a new case or change your filter settings."),
    actions: (0, _react2.jsx)(_button.EuiButton, {
      color: "primary",
      onClick: addCaseSpy,
      fill: true
    }, "Add a case"),
    footer: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_title.EuiTitle, {
      size: "xxs"
    }, (0, _react2.jsx)("h3", null, "Want to learn more?")), (0, _react2.jsx)(_link.EuiLink, {
      href: "#",
      onClick: addLinkSpy
    }, "Read the docs"))
  }));
});
describe('EuiEmptyPrompt', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after clicking Add a case button', function () {
      cy.get('button.euiButton').contains('Add a case').realClick();
      cy.get('@addCaseSpy').should('have.been.called');
      cy.checkAxe();
    });
    it('has zero violations after clicking Read the docs link', function () {
      cy.get('a.euiLink').contains('Read the docs').realClick();
      cy.get('@addLinkSpy').should('have.been.called');
      cy.checkAxe();
    });
  });
});