"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFailureStore = updateFailureStore;
var _boom = require("@hapi/boom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateFailureStore({
  esClient,
  dataStream,
  failureStoreEnabled,
  customRetentionPeriod,
  isServerless
}) {
  try {
    return await esClient.indices.putDataStreamOptions({
      name: dataStream,
      failure_store: {
        enabled: failureStoreEnabled,
        lifecycle: {
          data_retention: customRetentionPeriod,
          ...(isServerless ? {} : {
            enabled: failureStoreEnabled
          })
        }
      }
    }, {
      meta: true
    });
  } catch (error) {
    throw (0, _boom.badRequest)(`Failed to update failure store for data stream "${dataStream}": ${error}`);
  }
}