"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorMessagesFromEsShardFailures = void 0;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getErrorMessagesFromEsShardFailures = arg => {
  if ((0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['_shards'])) {
    var _arg$_shards$failures;
    return ((_arg$_shards$failures = arg._shards.failures) !== null && _arg$_shards$failures !== void 0 ? _arg$_shards$failures : []).map(failure => (0, _mlIsPopulatedObject.isPopulatedObject)(failure, ['reason']) && failure.reason.reason ? failure.reason.reason : undefined).filter(_mlIsDefined.isDefined);
  }
  return [];
};
exports.getErrorMessagesFromEsShardFailures = getErrorMessagesFromEsShardFailures;