"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SamplingMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_data_test_subject = require("../../util/get_data_test_subject");
var _random_sampler_range_slider = require("./random_sampler_range_slider");
var _random_sampler = require("../../../index_data_visualizer/constants/random_sampler");
var _probability_used = require("./probability_used");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/random_sampling_menu/random_sampling_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SamplingMenu = ({
  randomSampler,
  reload,
  id
}) => {
  const [showSamplingOptionsPopover, setShowSamplingOptionsPopover] = (0, _react.useState)(false);
  const samplingProbability = (0, _useObservable.default)(randomSampler.getProbability$(), randomSampler.getProbability());
  const setSamplingProbability = (0, _react.useCallback)(probability => {
    randomSampler.setProbability(probability);
    reload();
  }, [reload, randomSampler]);
  const randomSamplerPreference = (0, _useObservable.default)(randomSampler.getMode$(), randomSampler.getMode());
  const setRandomSamplerPreference = (0, _react.useCallback)(nextPref => {
    if (nextPref === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL) {
      // By default, when switching to manual, restore previously chosen probability
      // else, default to 0.001%
      const savedRandomSamplerProbability = randomSampler.getProbability();
      randomSampler.setProbability(savedRandomSamplerProbability && savedRandomSamplerProbability > 0 && savedRandomSamplerProbability <= 0.5 ? savedRandomSamplerProbability : _random_sampler.MIN_SAMPLER_PROBABILITY);
    }
    randomSampler.setMode(nextPref);
    reload();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [setSamplingProbability, randomSampler]);
  const {
    calloutInfoMessage,
    buttonText
  } = (0, _react.useMemo)(() => {
    switch (randomSamplerPreference) {
      case _random_sampler.RANDOM_SAMPLER_OPTION.OFF:
        return {
          calloutInfoMessage: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.offCallout.message', {
            defaultMessage: 'Random sampling can be turned on to increase the speed of analysis, although some accuracy will be lost.'
          }),
          buttonText: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.offCallout.button', {
            defaultMessage: 'No sampling'
          })
        };
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC:
        return {
          calloutInfoMessage: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onAutomaticCallout.message', {
            defaultMessage: 'The view will use random sampler aggregations. The probability is automatically set to balance accuracy and speed.'
          }),
          buttonText: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onAutomaticCallout.button', {
            defaultMessage: 'Auto sampling'
          })
        };
      case _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL:
      default:
        return {
          calloutInfoMessage: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onManualCallout.message', {
            defaultMessage: 'The view will use random sampler aggregations. A lower percentage probability increases performance, but some accuracy is lost.'
          }),
          buttonText: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.onManualCallout.button', {
            defaultMessage: 'Manual sampling'
          })
        };
    }
  }, [randomSamplerPreference]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('aiopsRandomSamplerOptionsPopover', id),
    id: "aiopsSamplingOptions",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('aiopsRandomSamplerOptionsButton', id),
      onClick: () => setShowSamplingOptionsPopover(!showSamplingOptionsPopover),
      iconSide: "right",
      iconType: "arrowDown",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, buttonText),
    isOpen: showSamplingOptionsPopover,
    closePopover: () => setShowSamplingOptionsPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: 'primary',
    title: calloutInfoMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('aiopsRandomSamplerOptionsFormRow', id),
    label: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerSettingsPopUp.randomSamplerRowLabel', {
      defaultMessage: 'Random sampling'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('aiopsRandomSamplerOptionsSelect', id),
    options: _random_sampler.RANDOM_SAMPLER_SELECT_OPTIONS,
    value: randomSamplerPreference,
    onChange: e => setRandomSamplerPreference(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })), randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_MANUAL ? /*#__PURE__*/_react.default.createElement(_random_sampler_range_slider.RandomSamplerRangeSlider, {
    samplingProbability: samplingProbability,
    setSamplingProbability: setSamplingProbability,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }) : null, randomSamplerPreference === _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC ? /*#__PURE__*/_react.default.createElement(_probability_used.ProbabilityUsedMessage, {
    samplingProbability: samplingProbability,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }) : null));
};
exports.SamplingMenu = SamplingMenu;