"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCAICasesBackfillTaskId = exports.CAI_CASES_SYNC_TYPE = exports.CAI_CASES_SOURCE_INDEX = exports.CAI_CASES_INDEX_VERSION = void 0;
exports.getCasesDestinationIndexAlias = getCasesDestinationIndexAlias;
exports.getCasesDestinationIndexName = getCasesDestinationIndexName;
exports.getCasesSynchronizationSourceQuery = exports.getCasesSourceQuery = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_CASES_INDEX_NAME_BASE = '.internal.cases';
function getCasesDestinationIndexName(spaceId, owner) {
  return `${CAI_CASES_INDEX_NAME_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_CASES_INDEX_ALIAS_BASE = '.cases';
function getCasesDestinationIndexAlias(spaceId, owner) {
  return `${CAI_CASES_INDEX_ALIAS_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_CASES_INDEX_VERSION = exports.CAI_CASES_INDEX_VERSION = 1;
const CAI_CASES_SYNC_TYPE = exports.CAI_CASES_SYNC_TYPE = 'cai_cases_sync';
const getCasesSourceQuery = (spaceId, owner) => ({
  bool: {
    filter: [{
      term: {
        type: 'cases'
      }
    }, {
      term: {
        namespaces: spaceId
      }
    }, {
      term: {
        'cases.owner': owner
      }
    }]
  }
});
exports.getCasesSourceQuery = getCasesSourceQuery;
const CAI_CASES_SOURCE_INDEX = exports.CAI_CASES_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_CASES_BACKFILL_TASK_ID = 'cai_cases_backfill_task';
const getCAICasesBackfillTaskId = (spaceId, owner) => {
  return `${CAI_CASES_BACKFILL_TASK_ID}-${owner}-${spaceId}`;
};
exports.getCAICasesBackfillTaskId = getCAICasesBackfillTaskId;
const getCasesSynchronizationSourceQuery = (lastSyncAt, spaceId, owner) => {
  var _getCasesSourceQuery$;
  return {
    bool: {
      filter: (_getCasesSourceQuery$ = getCasesSourceQuery(spaceId, owner).bool) === null || _getCasesSourceQuery$ === void 0 ? void 0 : _getCasesSourceQuery$.filter,
      must: [{
        bool: {
          should: [{
            range: {
              'cases.created_at': {
                gte: lastSyncAt.toISOString()
              }
            }
          }, {
            range: {
              'cases.updated_at': {
                gte: lastSyncAt.toISOString()
              }
            }
          }]
        }
      }]
    }
  };
};
exports.getCasesSynchronizationSourceQuery = getCasesSynchronizationSourceQuery;