"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _domain = require("../../../common/types/domain");
var _status2 = require("../status");
var _translations = require("../all_cases/translations");
var _use_should_disable_status = require("../actions/status/use_should_disable_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_action_bar/status_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatusContextMenuComponent = ({
  currentStatus,
  disabled = false,
  isLoading = false,
  onStatusChanged
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const shouldDisableStatus = (0, _use_should_disable_status.useShouldDisableStatus)();
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prevPopoverStatus => !prevPopoverStatus), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const popOverButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_status2.StatusPopoverButton, {
    disabled: disabled || isLoading,
    status: currentStatus,
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), [disabled, currentStatus, togglePopover, isLoading]);
  const onContextMenuItemClick = (0, _react.useCallback)(status => {
    closePopover();
    if (currentStatus !== status) {
      onStatusChanged(status);
    }
  }, [closePopover, currentStatus, onStatusChanged]);
  const panelItems = (0, _react.useMemo)(() => _domain.caseStatuses.filter(_ => !shouldDisableStatus([{
    status: currentStatus
  }])).map(status => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": `case-view-status-dropdown-${status}`,
    icon: status === currentStatus ? 'check' : 'empty',
    key: status,
    onClick: () => onContextMenuItemClick(status),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_status.Status, {
    status: status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }))), [currentStatus, onContextMenuItemClick, shouldDisableStatus]);
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_status.Status, {
      status: currentStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: popOverButton,
    closePopover: closePopover,
    "data-test-subj": "case-view-status-dropdown",
    id: "caseStatusPopover",
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    title: _translations.CHANGE_STATUS,
    items: panelItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
};
StatusContextMenuComponent.displayName = 'StatusContextMenu';
const StatusContextMenu = exports.StatusContextMenu = /*#__PURE__*/(0, _react.memo)(StatusContextMenuComponent);