"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rackVariables = exports.rackLineNumbers = exports.rackHighlightLang = exports.rack = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rackVariables = exports.rackVariables = {
  apmServiceName: 'service_name',
  secretToken: 'secret_token',
  apmServerUrl: 'server_url',
  apmEnvironment: 'environment'
};
const rackHighlightLang = exports.rackHighlightLang = 'rb';
const rackServiceNameHint = _i18n.i18n.translate('xpack.apm.tutorial.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment', {
  defaultMessage: "Defaults to the name of your Rack app's class."
});
const rackLineNumbers = exports.rackLineNumbers = {
  start: 1,
  highlight: '3, 5, 7, 9',
  annotations: {
    3: `${_shared_hints.serviceNameHint} ${rackServiceNameHint}`,
    5: _shared_hints.secretTokenHint,
    7: _shared_hints.serverUrlHint,
    9: _shared_hints.serviceEnvironmentHint
  }
};
const rack = exports.rack = `# config/elastic_apm.yml:

${rackVariables.apmServiceName}: '{{{apmServiceName}}}'

${rackVariables.secretToken}: '{{{secretToken}}}'

${rackVariables.apmServerUrl}: '{{{apmServerUrl}}}',

${rackVariables.apmEnvironment}: '{{{apmEnvironment}}}'`;