"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockApmPluginContextWrapper = MockApmPluginContextWrapper;
exports.observabilityLogsExplorerLocatorsMock = exports.mockApmPluginContextValue = exports.logsLocatorMock = void 0;
var _mocks = require("@kbn/core/public/mocks");
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ml-plugin/public");
var _public3 = require("@kbn/observability-plugin/public");
var _url_service = require("@kbn/share-plugin/common/url_service");
var _mocks2 = require("@kbn/share-plugin/public/mocks");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _history = require("history");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _apm_route_config = require("../../components/routing/apm_route_config");
var _create_call_apm_api = require("../../services/rest/create_call_apm_api");
var _apm_plugin_context = require("./apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/apm_plugin/mock_apm_plugin_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const coreStart = _mocks.coreMock.createStart({
  basePath: '/basepath'
});
const mockShareService = {
  url: {
    locators: {
      get: jest.fn(() => {
        // MlManagementLocatorInternal wraps the management locator (getUrl mocked below) and adds path formatting to match ML app paths
        return {
          getUrl: async ({
            sectionId,
            appId
          }) => {
            return `/app/management/${sectionId}/${appId}`;
          }
        };
      })
    }
  }
};
const mockCore = (0, _lodash.merge)({}, coreStart, {
  application: {
    capabilities: {
      apm: {},
      ml: {},
      savedObjectsManagement: {
        edit: true
      }
    }
  },
  uiSettings: {
    get: key => {
      const uiSettings = {
        [_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES]: [{
          from: 'now/d',
          to: 'now/d',
          display: 'Today'
        }, {
          from: 'now/w',
          to: 'now/w',
          display: 'This week'
        }, {
          from: 'now-1m',
          to: 'now',
          display: 'Last 1 minute'
        }, {
          from: 'now-15m',
          to: 'now',
          display: 'Last 15 minutes'
        }, {
          from: 'now-30m',
          to: 'now',
          display: 'Last 30 minutes'
        }, {
          from: 'now-1h',
          to: 'now',
          display: 'Last 1 hour'
        }, {
          from: 'now-24h',
          to: 'now',
          display: 'Last 24 hours'
        }, {
          from: 'now-7d',
          to: 'now',
          display: 'Last 7 days'
        }, {
          from: 'now-30d',
          to: 'now',
          display: 'Last 30 days'
        }, {
          from: 'now-90d',
          to: 'now',
          display: 'Last 90 days'
        }, {
          from: 'now-1y',
          to: 'now',
          display: 'Last 1 year'
        }],
        [_common.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS]: {
          from: 'now-15m',
          to: 'now'
        },
        [_common.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS]: {
          pause: false,
          value: 100000
        },
        [_public3.enableComparisonByDefault]: true
      };
      return uiSettings[key];
    }
  },
  data: {
    query: {
      queryString: {
        getQuery: jest.fn(),
        setQuery: jest.fn(),
        clearQuery: jest.fn()
      },
      timefilter: {
        timefilter: {
          setTime: jest.fn(),
          setRefreshInterval: jest.fn(),
          getTime: jest.fn()
        }
      }
    }
  },
  observabilityShared: {
    navigation: {
      PageTemplate: ({
        children
      }) => /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 70
        }
      }, children)
    }
  }
});
const mockConfig = {
  serviceMapEnabled: true,
  ui: {
    enabled: false
  },
  latestAgentVersionsUrl: '',
  serverlessOnboarding: false,
  managedServiceUrl: '',
  featureFlags: {
    agentConfigurationAvailable: true,
    configurableIndicesAvailable: true,
    infrastructureTabAvailable: true,
    infraUiAvailable: true,
    migrationToFleetAvailable: true,
    sourcemapApiAvailable: true,
    storageExplorerAvailable: true,
    // to be removed in https://github.com/elastic/kibana/issues/221904
    profilingIntegrationAvailable: false,
    ruleFormV2Enabled: false
  },
  serverless: {
    enabled: false
  }
};
const urlService = new _url_service.UrlService({
  navigate: async () => {},
  getUrl: async ({
    app,
    path
  }, {
    absolute
  }) => {
    return `${absolute ? 'http://localhost:8888' : ''}/app/${app}${path}`;
  },
  shortUrls: () => ({
    get: () => {}
  })
});
const locator = urlService.locators.create(new _public2.MlLocatorDefinition());
const mlManagementLocator = new _public2.MlManagementLocatorInternal(mockShareService);
const mockPlugin = {
  ml: {
    locator,
    managementLocator: mlManagementLocator
  },
  data: {
    query: {
      timefilter: {
        timefilter: {
          setTime: () => {},
          getTime: () => ({})
        }
      }
    }
  },
  share: {
    url: {
      locators: {
        get: jest.fn()
      }
    }
  },
  observabilityShared: {
    locators: {
      profiling: {
        flamegraphLocator: {
          getRedirectUrl: () => '/profiling/flamegraphs/flamegraph'
        },
        topNFunctionsLocator: {
          getRedirectUrl: () => '/profiling/functions/topn'
        },
        stacktracesLocator: {
          getRedirectUrl: () => '/profiling/stacktraces/threads'
        }
      }
    }
  }
};
const observabilityLogsExplorerLocatorsMock = exports.observabilityLogsExplorerLocatorsMock = {
  allDatasetsLocator: _mocks2.sharePluginMock.createLocator(),
  singleDatasetLocator: _mocks2.sharePluginMock.createLocator()
};
const logsLocatorMock = exports.logsLocatorMock = _mocks2.sharePluginMock.createLocator();
const mockCorePlugins = {
  embeddable: {},
  inspector: {},
  maps: {},
  observability: {},
  observabilityShared: {},
  data: {}
};
const mockUnifiedSearch = {
  ui: {
    SearchBar: () => /*#__PURE__*/_react.default.createElement("div", {
      className: "searchBar",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 22
      }
    })
  }
};
const mockApmPluginContextValue = exports.mockApmPluginContextValue = {
  appMountParameters: _mocks.coreMock.createAppMountParameters('/basepath'),
  config: mockConfig,
  core: mockCore,
  plugins: mockPlugin,
  observabilityRuleTypeRegistry: (0, _public3.createObservabilityRuleTypeRegistryMock)(),
  corePlugins: mockCorePlugins,
  deps: {},
  share: _mocks2.sharePluginMock.createSetupContract(),
  unifiedSearch: mockUnifiedSearch,
  uiActions: {
    getTriggerCompatibleActions: () => Promise.resolve([])
  },
  observabilityAIAssistant: {
    service: {
      setScreenContext: jest.fn().mockImplementation(() => _lodash.noop)
    }
  }
};
function MockApmPluginContextWrapper({
  children,
  value = {},
  history
}) {
  const contextValue = (0, _lodash.merge)({}, mockApmPluginContextValue, value);
  if (contextValue.core) {
    (0, _create_call_apm_api.createCallApmApi)(contextValue.core);
  }
  performance.mark = jest.fn();
  performance.clearMeasures = jest.fn();
  const contextHistory = (0, _reactRouterDom.useHistory)();
  const usedHistory = (0, _react.useMemo)(() => {
    return history || contextHistory || (0, _history.createMemoryHistory)({
      initialEntries: ['/services/?rangeFrom=now-15m&rangeTo=now']
    });
  }, [history, contextHistory]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.__IntlProvider, {
    locale: "en",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: contextValue.core,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_plugin_context.ApmPluginContext.Provider, {
    value: contextValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    router: _apm_route_config.apmRouter,
    history: usedHistory,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  }, children))));
}