"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MostUsedCharts = MostUsedCharts;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sunburst_chart = require("./sunburst_chart");
var _use_breakpoints = require("../../../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _mobile_types = require("../../../../../../common/mobile_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/most_used_charts/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MOST_USED_CHARTS = [{
  key: _mobile_types.MobileProperty.Device,
  label: _i18n.i18n.translate('xpack.apm.mobile.charts.device', {
    defaultMessage: 'Devices'
  })
}, {
  key: _mobile_types.MobileProperty.NetworkConnectionType,
  label: _i18n.i18n.translate('xpack.apm.mobile.charts.nct', {
    defaultMessage: 'Network Connection Type'
  })
}, {
  key: _mobile_types.MobileProperty.OsVersion,
  label: _i18n.i18n.translate('xpack.apm.mobile.charts.osVersion', {
    defaultMessage: 'OS version'
  })
}, {
  key: _mobile_types.MobileProperty.AppVersion,
  label: _i18n.i18n.translate('xpack.apm.mobile.charts.appVersion', {
    defaultMessage: 'App version'
  })
}];
function MostUsedCharts({
  start,
  end,
  kuery,
  environment,
  transactionType,
  serviceName
}) {
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const resizeRef = (0, _react.useRef)(null);
  const dimensions = (0, _eui.useResizeObserver)(resizeRef.current);
  const groupDirection = isLarge ? 'column' : 'row';
  const {
    data = {
      mostUsedCharts: []
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/most_used_charts', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          kuery,
          transactionType
        }
      }
    });
  }, [start, end, environment, kuery, serviceName, transactionType]);
  const chartWidth = isLarge ? dimensions.width : dimensions.width / MOST_USED_CHARTS.length;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: groupDirection,
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, MOST_USED_CHARTS.map(({
    key,
    label
  }) => {
    var _data$mostUsedCharts$;
    const chartData = (data === null || data === void 0 ? void 0 : (_data$mostUsedCharts$ = data.mostUsedCharts.find(chart => chart.key === key)) === null || _data$mostUsedCharts$ === void 0 ? void 0 : _data$mostUsedCharts$.options) || [];
    return /*#__PURE__*/_react.default.createElement("div", {
      key: key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_sunburst_chart.SunburstChart, {
      data: chartData,
      label: label,
      chartKey: key,
      fetchStatus: status,
      chartWidth: chartWidth,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    }));
  })));
}