"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileSearchBar = MobileSearchBar;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _time_comparison = require("../../shared/time_comparison");
var _filters = require("./service_overview/filters");
var _unified_search_bar = require("../../shared/unified_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MobileSearchBar({
  hidden = false,
  showUnifiedSearchBar = true,
  showTimeComparison = false,
  showTransactionTypeSelector = false,
  showQueryInput = true,
  showMobileFilters = false,
  searchBarPlaceholder
}) {
  const {
    isSmall,
    isMedium,
    isLarge,
    isXl,
    isXXXL
  } = (0, _use_breakpoints.useBreakpoints)();
  if (hidden) {
    return null;
  }
  const searchBarDirection = isXXXL || !isXl && !showTimeComparison ? 'row' : 'column';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: searchBarDirection,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isLarge ? 'columnReverse' : 'row',
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, showUnifiedSearchBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_unified_search_bar.UnifiedSearchBar, {
    placeholder: searchBarPlaceholder,
    showQueryInput: showQueryInput,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: isMedium ? 's' : 'm',
    direction: isLarge || isMedium ? 'column' : 'row',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, showTimeComparison && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isSmall,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_time_comparison.TimeComparison, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  })), showMobileFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_filters.MobileFilters, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
}