"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializePatternAnalysisControls = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializePatternAnalysisControls = state => {
  const dataViewId = new _rxjs.BehaviorSubject(state.dataViewId);
  const fieldName = new _rxjs.BehaviorSubject(state.fieldName);
  const minimumTimeRangeOption = new _rxjs.BehaviorSubject(state.minimumTimeRangeOption);
  const randomSamplerMode = new _rxjs.BehaviorSubject(state.randomSamplerMode);
  const randomSamplerProbability = new _rxjs.BehaviorSubject(state.randomSamplerProbability);
  const updateUserInput = update => {
    dataViewId.next(update.dataViewId);
    fieldName.next(update.fieldName);
    minimumTimeRangeOption.next(update.minimumTimeRangeOption);
    randomSamplerMode.next(update.randomSamplerMode);
    randomSamplerProbability.next(update.randomSamplerProbability);
  };
  const serializePatternAnalysisChartState = () => {
    return {
      dataViewId: dataViewId.getValue(),
      fieldName: fieldName.getValue(),
      minimumTimeRangeOption: minimumTimeRangeOption.getValue(),
      randomSamplerMode: randomSamplerMode.getValue(),
      randomSamplerProbability: randomSamplerProbability.getValue()
    };
  };
  const patternAnalysisControlsComparators = {
    dataViewId: 'referenceEquality',
    fieldName: 'referenceEquality',
    minimumTimeRangeOption: 'referenceEquality',
    randomSamplerMode: 'referenceEquality',
    randomSamplerProbability: 'referenceEquality'
  };
  return {
    patternAnalysisControlsApi: {
      dataViewId,
      fieldName,
      minimumTimeRangeOption,
      randomSamplerMode,
      randomSamplerProbability,
      updateUserInput
    },
    serializePatternAnalysisChartState,
    patternAnalysisControlsComparators
  };
};
exports.initializePatternAnalysisControls = initializePatternAnalysisControls;