/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postings;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.postings.ES812PostingsReader;
import org.elasticsearch.index.codec.postings.ES812PostingsWriter;
import org.elasticsearch.index.codec.postings.Lucene90BlockTreeTermsWriter;

public class ES812PostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    static final int MAX_SKIP_LEVELS = 10;
    static final String CODEC_NAME = "ES812Postings";
    static final String TERMS_CODEC = "ES812PostingsWriterTerms";
    static final String DOC_CODEC = "ES812PostingsWriterDoc";
    static final String POS_CODEC = "ES812PostingsWriterPos";
    static final String PAY_CODEC = "ES812PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    public ES812PostingsFormat() {
        super(CODEC_NAME);
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        ES812PostingsWriter postingsWriter = new ES812PostingsWriter(state);
        boolean success = false;
        try {
            Lucene90BlockTreeTermsWriter ret = new Lucene90BlockTreeTermsWriter(state, (PostingsWriterBase)postingsWriter, 25, 48);
            success = true;
            Lucene90BlockTreeTermsWriter lucene90BlockTreeTermsWriter = ret;
            return lucene90BlockTreeTermsWriter;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)postingsWriter));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        ES812PostingsReader postingsReader = new ES812PostingsReader(state);
        boolean success = false;
        try {
            Lucene90BlockTreeTermsReader ret = new Lucene90BlockTreeTermsReader((PostingsReaderBase)postingsReader, state);
            success = true;
            Lucene90BlockTreeTermsReader lucene90BlockTreeTermsReader = ret;
            return lucene90BlockTreeTermsReader;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)postingsReader));
            }
        }
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long skipOffset = -1L;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom((TermState)this);
            return other;
        }

        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.skipOffset = other.skipOffset;
            this.singletonDocID = other.singletonDocID;
        }

        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

