/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.search.Query;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.support.FieldNameTranslators;

public class RoleBoolQueryBuilder
extends BoolQueryBuilder {
    private static final Set<String> FIELDS_ALLOWED_TO_QUERY = Set.of("_id", "type");

    private RoleBoolQueryBuilder() {
    }

    public static RoleBoolQueryBuilder build(QueryBuilder queryBuilder, @Nullable Consumer<String> fieldNameVisitor) {
        RoleBoolQueryBuilder finalQuery = new RoleBoolQueryBuilder();
        if (queryBuilder != null) {
            QueryBuilder processedQuery = FieldNameTranslators.ROLE_FIELD_NAME_TRANSLATORS.translateQueryBuilderFields(queryBuilder, fieldNameVisitor);
            finalQuery.must(processedQuery);
        }
        finalQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role"));
        if (fieldNameVisitor != null) {
            fieldNameVisitor.accept(RoleDescriptor.Fields.TYPE.getPreferredName());
        }
        return finalQuery;
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        context.setAllowedFields(RoleBoolQueryBuilder::isIndexFieldNameAllowed);
        return super.doToQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext instanceof SearchExecutionContext) {
            ((SearchExecutionContext)queryRewriteContext).setAllowedFields(RoleBoolQueryBuilder::isIndexFieldNameAllowed);
        }
        return super.doRewrite(queryRewriteContext);
    }

    static boolean isIndexFieldNameAllowed(String fieldName) {
        return FIELDS_ALLOWED_TO_QUERY.contains(fieldName) || FieldNameTranslators.ROLE_FIELD_NAME_TRANSLATORS.isIndexFieldSupported(fieldName);
    }
}

