/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto.content;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import shadow.fasterxml.jackson.core.JsonGenerator;
import shadow.org.elasticsearch.xpack.sql.proto.StringUtils;

public class GeneratorUtils {
    private static final Map<Class<?>, Writer> WRITERS = new HashMap();

    private static Writer valueWriter(Writer writer) {
        return (g, v) -> {
            if (v == null) {
                g.writeNull();
            } else {
                writer.write(g, v);
            }
        };
    }

    private static Writer valuesWriter(Writer writer) {
        return (g, v) -> {
            if (v == null) {
                g.writeNull();
            } else {
                g.writeStartArray();
                writer.write(g, v);
                g.writeEndArray();
            }
        };
    }

    private GeneratorUtils() {
    }

    public static void unknownValue(JsonGenerator generator, Object value) throws IOException {
        GeneratorUtils.unknownValue(generator, value, false);
    }

    private static void unknownValue(JsonGenerator generator, Object value, boolean ensureNoSelfReferences) throws IOException {
        if (value == null) {
            generator.writeNull();
            return;
        }
        Writer writer = WRITERS.get(value.getClass());
        if (writer != null) {
            writer.write(generator, value);
        } else if (value instanceof Path) {
            GeneratorUtils.value(generator, (Path)value);
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            GeneratorUtils.map(generator, valueMap, ensureNoSelfReferences, true);
        } else if (value instanceof Iterable) {
            GeneratorUtils.iterable(generator, (Iterable)value, ensureNoSelfReferences);
        } else if (value instanceof Object[]) {
            GeneratorUtils.array(generator, (Object[])value, ensureNoSelfReferences);
        } else if (value instanceof Enum) {
            generator.writeString(Objects.toString(value));
        } else {
            throw new IllegalArgumentException("cannot write xcontent for unknown value of type " + value.getClass());
        }
    }

    private static void map(JsonGenerator generator, Map<String, ?> map, boolean ensureNoSelfReferences, boolean writeStartAndEndHeaders) throws IOException {
        if (map == null) {
            generator.writeNull();
            return;
        }
        if (ensureNoSelfReferences) {
            GeneratorUtils.ensureNoSelfReferences(map);
        }
        if (writeStartAndEndHeaders) {
            generator.writeStartObject();
        }
        for (Map.Entry<String, ?> value : map.entrySet()) {
            generator.writeFieldName(value.getKey());
            GeneratorUtils.unknownValue(generator, value.getValue(), false);
        }
        if (writeStartAndEndHeaders) {
            generator.writeEndObject();
        }
    }

    private static void iterable(JsonGenerator generator, Iterable<?> values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            generator.writeNull();
            return;
        }
        if (values instanceof Path) {
            GeneratorUtils.value(generator, (Path)values);
        } else {
            if (ensureNoSelfReferences) {
                GeneratorUtils.ensureNoSelfReferences(values);
            }
            generator.writeStartArray();
            for (Object value : values) {
                GeneratorUtils.unknownValue(generator, value, false);
            }
            generator.writeEndArray();
        }
    }

    private static void array(JsonGenerator generator, Object[] values, boolean ensureNoSelfReferences) throws IOException {
        if (values == null) {
            generator.writeNull();
        } else {
            GeneratorUtils.iterable(generator, Arrays.asList(values), ensureNoSelfReferences);
        }
    }

    private static void ensureNoSelfReferences(Object value) {
        Iterable<?> it = GeneratorUtils.convert(value);
        if (it != null) {
            GeneratorUtils.ensureNoSelfReferences(it, value, Collections.newSetFromMap(new IdentityHashMap()));
        }
    }

    private static Iterable<?> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return ((Map)value).values();
        }
        if (value instanceof Iterable && !(value instanceof Path)) {
            return (Iterable)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    private static void ensureNoSelfReferences(Iterable<?> value, Object originalReference, Set<Object> ancestors) {
        if (value != null) {
            if (!ancestors.add(originalReference)) {
                throw new IllegalArgumentException("Iterable object is self-referencing itself");
            }
            for (Object o : value) {
                GeneratorUtils.ensureNoSelfReferences(GeneratorUtils.convert(o), o, ancestors);
            }
            ancestors.remove(originalReference);
        }
    }

    public static void value(JsonGenerator generator, Path path) throws IOException {
        if (path == null) {
            generator.writeNull();
        } else {
            generator.writeString(path.toString());
        }
    }

    static {
        WRITERS.put(Boolean.class, GeneratorUtils.valueWriter((p, v) -> p.writeBoolean((Boolean)v)));
        WRITERS.put(boolean[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (boolean b : (boolean[])v) {
                p.writeBoolean(b);
            }
        }));
        WRITERS.put(Byte.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber(((Byte)v).byteValue())));
        WRITERS.put(byte[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (byte b : (byte[])v) {
                p.writeNumber(b);
            }
        }));
        WRITERS.put(Date.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber(((Date)v).getTime())));
        WRITERS.put(Double.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber((Double)v)));
        WRITERS.put(double[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (double d : (double[])v) {
                p.writeNumber(d);
            }
        }));
        WRITERS.put(Float.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber(((Float)v).floatValue())));
        WRITERS.put(float[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (float f : (float[])v) {
                p.writeNumber(f);
            }
        }));
        WRITERS.put(Integer.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber((Integer)v)));
        WRITERS.put(int[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (int i : (int[])v) {
                p.writeNumber(i);
            }
        }));
        WRITERS.put(Long.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber((Long)v)));
        WRITERS.put(long[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (long l : (long[])v) {
                p.writeNumber(l);
            }
        }));
        WRITERS.put(Short.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber((Short)v)));
        WRITERS.put(short[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (short s : (short[])v) {
                p.writeNumber(s);
            }
        }));
        WRITERS.put(String.class, GeneratorUtils.valueWriter((p, v) -> p.writeString((String)v)));
        WRITERS.put(String[].class, GeneratorUtils.valuesWriter((p, v) -> {
            for (String s : (String[])v) {
                p.writeString(s);
            }
        }));
        WRITERS.put(Locale.class, GeneratorUtils.valueWriter((p, v) -> p.writeString(v.toString())));
        WRITERS.put(Class.class, GeneratorUtils.valueWriter((p, v) -> p.writeString(v.toString())));
        WRITERS.put(ZonedDateTime.class, GeneratorUtils.valueWriter((p, v) -> p.writeString(StringUtils.toString(v))));
        WRITERS.put(BigInteger.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber((BigInteger)v)));
        WRITERS.put(BigDecimal.class, GeneratorUtils.valueWriter((p, v) -> p.writeNumber((BigDecimal)v)));
    }

    @FunctionalInterface
    private static interface Writer {
        public void write(JsonGenerator var1, Object var2) throws IOException;
    }
}

