/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.execution.QueueBatch;
import org.logstash.ext.JrubyEventExtLibrary;

public final class MemoryReadBatch
implements QueueBatch {
    private final Collection<JrubyEventExtLibrary.RubyEvent> events;

    public static boolean isCancelled(JrubyEventExtLibrary.RubyEvent event) {
        return event.getEvent().isCancelled();
    }

    public static MemoryReadBatch create(Collection<JrubyEventExtLibrary.RubyEvent> events) {
        return new MemoryReadBatch(events);
    }

    public static MemoryReadBatch create() {
        return new MemoryReadBatch(new ArrayList<JrubyEventExtLibrary.RubyEvent>());
    }

    private MemoryReadBatch(Collection<JrubyEventExtLibrary.RubyEvent> events) {
        this.events = events;
    }

    @Override
    public RubyArray<JrubyEventExtLibrary.RubyEvent> to_a() {
        RubyArray result = RubyUtil.RUBY.newArray(this.events.size());
        for (JrubyEventExtLibrary.RubyEvent e : this.events) {
            if (MemoryReadBatch.isCancelled(e)) continue;
            result.append((IRubyObject)e);
        }
        return result;
    }

    @Override
    public Collection<JrubyEventExtLibrary.RubyEvent> events() {
        return this.events;
    }

    @Override
    public int filteredSize() {
        return this.events.size();
    }

    @Override
    public void close() {
    }
}

