"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserEntityOverview = exports.USER_PREVIEW_BANNER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_non_closed_alerts = require("../../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _search_strategy = require("../../../../../common/search_strategy");
var _context = require("../../shared/context");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _utils = require("../../shared/utils");
var _cell_actions = require("../../shared/components/cell_actions");
var _first_last_seen = require("../../../../common/components/first_last_seen/first_last_seen");
var _types = require("../../../../../common/entity_analytics/types");
var _empty_value = require("../../../../common/components/empty_value");
var _page = require("../../../../common/components/page");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _common = require("../../../../entity_analytics/components/severity/common");
var _containers = require("../../../../sourcerer/containers");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_risk_score = require("../../../../entity_analytics/api/hooks/use_risk_score");
var _translations = require("../../../../overview/components/user_overview/translations");
var _test_ids = require("./test_ids");
var _observed_details = require("../../../../explore/users/containers/users/observed_details");
var _common2 = require("../../../../overview/components/common");
var _preview_link = require("../../../shared/components/preview_link");
var _misconfiguration_insight = require("../../shared/components/misconfiguration_insight");
var _alert_count_insight = require("../../shared/components/alert_count_insight");
var _use_navigate_to_user_details = require("../../../entity_details/user_right/hooks/use_navigate_to_user_details");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/user_entity_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const USER_ICON = 'user';
const USER_ENTITY_OVERVIEW_ID = 'user-entity-overview';
const USER_PREVIEW_BANNER = exports.USER_PREVIEW_BANNER = {
  title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.user.userPreviewTitle', {
    defaultMessage: 'Preview user details'
  }),
  backgroundColor: 'warning',
  textColor: 'warning'
};

/**
 * User preview content for the entities preview in right flyout. It contains ip addresses and risk level
 */
const UserEntityOverview = ({
  userName
}) => {
  const {
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const filterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const [isUserDetailsLoading, {
    userDetails
  }] = (0, _observed_details.useObservedUserDetails)({
    endDate: to,
    userName,
    indexNames: selectedPatterns,
    startDate: from
  });
  const {
    data: userRisk,
    isAuthorized,
    loading: isRiskScoreLoading
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _types.EntityType.user,
    timerange
  });
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  const isRiskScoreExist = !!(userRiskData !== null && userRiskData !== void 0 && userRiskData.user.risk);
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(_types.EntityIdentifierFields.userName, userName);
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: _types.EntityIdentifierFields.userName,
    value: userName,
    to,
    from,
    queryId: USER_ENTITY_OVERVIEW_ID
  });
  const {
    openDetailsPanel
  } = (0, _use_navigate_to_user_details.useNavigateToUserDetails)({
    userName,
    scopeId,
    isRiskScoreExist,
    hasMisconfigurationFindings,
    hasNonClosedAlerts,
    isPreviewMode: true,
    // setting to true to always open a new user flyout
    contextID: 'UserEntityOverview'
  });
  const userDomainValue = (0, _react.useMemo)(() => (0, _utils.getField)((0, _fp.getOr)([], 'user.domain', userDetails)), [userDetails]);
  const userDomain = (0, _react.useMemo)(() => [{
    title: _translations.USER_DOMAIN,
    description: userDomainValue ? /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
      field: 'user.domain',
      value: userDomainValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }, userDomainValue) : (0, _empty_value.getEmptyTagValue)()
  }], [userDomainValue]);
  const userLastSeen = (0, _react.useMemo)(() => [{
    title: _translations.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: selectedPatterns,
      field: _constants.USER_NAME_FIELD_NAME,
      value: userName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    })
  }], [userName, selectedPatterns]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [userRiskLevel] = (0, _react.useMemo)(() => [{
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexEnd",
      gutterSize: "none",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 13
      }
    }, _translations.USER_RISK_LEVEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_common2.RiskScoreDocTooltip, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 15
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      severity: userRiskData.user.risk.calculated_level,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 15
      }
    }) : (0, _empty_value.getEmptyTagValue)())
  }], [userRiskData]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    responsive: false,
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: USER_ICON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
    field: _constants.USER_NAME_FIELD_NAME,
    value: userName,
    scopeId: scopeId,
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_LINK_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                  font-size: ${xsFontSize};
                  font-weight: ${euiTheme.font.weight.bold};
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }, userName))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }, isUserDetailsLoading || isRiskScoreLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.entities.userLoadingAriaLabel', {
      defaultMessage: 'user overview'
    }),
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_LOADING_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_USER_OVERVIEW_DOMAIN_TEST_ID,
    descriptionList: userDomain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 13
    }
  }, isAuthorized ? /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_RISK_LEVEL_TEST_ID,
    listItems: [userRiskLevel],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    dataTestSubj: _test_ids.ENTITIES_USER_OVERVIEW_LAST_SEEN_TEST_ID,
    descriptionList: userLastSeen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_alert_count_insight.AlertCountInsight, {
    fieldName: 'user.name',
    name: userName,
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_ALERT_COUNT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_misconfiguration_insight.MisconfigurationsInsight, {
    fieldName: 'user.name',
    name: userName,
    openDetailsPanel: openDetailsPanel,
    "data-test-subj": _test_ids.ENTITIES_USER_OVERVIEW_MISCONFIGURATIONS_TEST_ID,
    telemetryKey: _ui_metrics.MISCONFIGURATION_INSIGHT_USER_ENTITY_OVERVIEW,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 7
    }
  }));
};
exports.UserEntityOverview = UserEntityOverview;