"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionPreviewContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_license = require("../../../../common/hooks/use_license");
var _session_preview = require("./session_preview");
var _use_session_view_config = require("../../shared/hooks/use_session_view_config");
var _context = require("../../shared/context");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _test_ids = require("./test_ids");
var _use_navigate_to_session_view = require("../../shared/hooks/use_navigate_to_session_view");
var _session_view_no_data_message = require("../../shared/components/session_view_no_data_message");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/session_preview_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Checks if the SessionView component is available, if so render it or else render an error message
 */
const SessionPreviewContainer = () => {
  const {
    eventId,
    indexName,
    scopeId,
    getFieldsData,
    isRulePreview,
    isPreviewMode,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();

  // decide whether to show the session view or not
  const sessionViewConfig = (0, _use_session_view_config.useSessionViewConfig)({
    getFieldsData,
    dataFormattedForFieldBrowser
  });
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const isEnabled = sessionViewConfig && isEnterprisePlus;
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const {
    navigateToSessionView
  } = (0, _use_navigate_to_session_view.useNavigateToSessionView)({
    eventId,
    indexName,
    isFlyoutOpen: true,
    scopeId,
    isPreviewMode
  });
  const iconType = (0, _react.useMemo)(() => !isPreviewMode ? 'arrowStart' : undefined, [isPreviewMode]);
  const isNavigationEnabled = (0, _react.useMemo)(() => {
    // if the session view is not enabled or in rule preview mode, the navigation is not enabled
    if (!isEnabled || isRulePreview) {
      return false;
    }
    // if the new navigation is enabled, the navigation is enabled (flyout or timeline)
    if (isNewNavigationEnabled) {
      return true;
    }
    // if the new navigation is not enabled, the navigation is enabled if the flyout is not in preview mode
    return !isPreviewMode;
  }, [isNewNavigationEnabled, isPreviewMode, isEnabled, isRulePreview]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.sessionPreviewTitle",
        defaultMessage: "Session viewer preview",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 11
        }
      }),
      iconType,
      ...(isNavigationEnabled && {
        link: {
          callback: navigateToSessionView,
          tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.sessionPreviewTooltip",
            defaultMessage: "Investigate in timeline",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 80,
              columnNumber: 15
            }
          })
        }
      })
    },
    "data-test-subj": _test_ids.SESSION_PREVIEW_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, isEnabled ? /*#__PURE__*/_react.default.createElement(_session_preview.SessionPreview, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_session_view_no_data_message.SessionViewNoDataMessage, {
    isEnterprisePlus: isEnterprisePlus,
    hasSessionViewConfig: sessionViewConfig !== null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }));
};
exports.SessionPreviewContainer = SessionPreviewContainer;