"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_prevalence = require("../../shared/hooks/use_prevalence");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _left = require("../../left");
var _prevalence_details = require("../../left/components/prevalence_details");
var _insights_summary_row = require("./insights_summary_row");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/prevalence_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UNCOMMON = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.prevalence.uncommonLabel",
  defaultMessage: "Uncommon",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 3
  }
});
const PERCENTAGE_THRESHOLD = 0.1; // we show the prevalence if its value is below 10%
const DEFAULT_FROM = 'now-30d';
const DEFAULT_TO = 'now';

/**
 * Prevalence section under Insights section, overview tab.
 * The component fetches the necessary data at once. The loading and error states are handled by the ExpandablePanel component.
 */
const PrevalenceOverview = () => {
  const {
    dataFormattedForFieldBrowser,
    investigationFields,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const {
    navigateToLeftPanel: goToPrevalenceTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: _prevalence_details.PREVALENCE_TAB_ID
  });
  const {
    loading,
    error,
    data
  } = (0, _use_prevalence.usePrevalence)({
    dataFormattedForFieldBrowser,
    investigationFields,
    interval: {
      from: DEFAULT_FROM,
      to: DEFAULT_TO
    }
  });

  // only show data if the host prevalence is below 10%
  const uncommonData = (0, _react.useMemo)(() => data.filter(d => isFinite(d.hostPrevalence) && d.hostPrevalence > 0 && d.hostPrevalence < PERCENTAGE_THRESHOLD), [data]);
  const link = (0, _react.useMemo)(() => isLinkEnabled ? {
    callback: goToPrevalenceTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.prevalence.prevalenceTooltip",
      defaultMessage: "Show all prevalence",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    })
  } : undefined, [goToPrevalenceTab, isLinkEnabled]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.prevalence.prevalenceTitle",
        defaultMessage: "Prevalence",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      }),
      link,
      iconType: !isPreviewMode ? 'arrowStart' : undefined
    },
    content: {
      loading,
      error
    },
    "data-test-subj": _test_ids.PREVALENCE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, uncommonData.length > 0 ? uncommonData.map(d => /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, d.field, ',', " ", d.values.toString()),
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 22
      }
    }, UNCOMMON),
    "data-test-subj": `${_test_ids.PREVALENCE_TEST_ID}${d.field}`,
    key: `${_test_ids.PREVALENCE_TEST_ID}${d.field}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.prevalence.noDataDescription",
    defaultMessage: "No prevalence data available.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  })));
};
exports.PrevalenceOverview = PrevalenceOverview;
PrevalenceOverview.displayName = 'PrevalenceOverview';