"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFieldsCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_agent_type_for_agent_id_field = require("../../../../common/lib/endpoint/utils/get_agent_type_for_agent_id_field");
var _agent_status = require("../../../../common/components/endpoint/agents/agent_status");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _test_ids = require("./test_ids");
var _link_utils = require("../../../shared/utils/link_utils");
var _preview_link = require("../../../shared/components/preview_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/highlighted_fields_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_ARRAY = [];
/**
 * Renders a component in the highlighted fields table cell based on the field name
 */
const HighlightedFieldsCell = ({
  values,
  field,
  originalField = '',
  scopeId = '',
  showPreview = false,
  ancestorsIndexName,
  displayValuesLimit = 2
}) => {
  const agentType = (0, _react.useMemo)(() => {
    return (0, _get_agent_type_for_agent_id_field.getAgentTypeForAgentIdField)(originalField);
  }, [originalField]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isContentExpanded, setIsContentExpanded] = (0, _react.useState)(false);
  const toggleContentExpansion = (0, _react.useCallback)(() => setIsContentExpanded(currentIsOpen => !currentIsOpen), []);
  const visibleValues = (0, _react.useMemo)(() => {
    var _values$length;
    /**
     * Check if a limit was set and if the limit
     * is within the values size
     */
    if (displayValuesLimit && displayValuesLimit > 0 && displayValuesLimit < ((_values$length = values === null || values === void 0 ? void 0 : values.length) !== null && _values$length !== void 0 ? _values$length : 0)) {
      return values === null || values === void 0 ? void 0 : values.slice(0, displayValuesLimit);
    }
    return values;
  }, [values, displayValuesLimit]);
  const overflownValues = (0, _react.useMemo)(() => {
    var _values$length2;
    /**
     * Check if a limit was set and if the limit
     * is within the values size
     */
    if (displayValuesLimit && displayValuesLimit > 0 && displayValuesLimit < ((_values$length2 = values === null || values === void 0 ? void 0 : values.length) !== null && _values$length2 !== void 0 ? _values$length2 : 0)) {
      return values === null || values === void 0 ? void 0 : values.slice(displayValuesLimit);
    }
    return EMPTY_ARRAY;
  }, [values, displayValuesLimit]);
  const isContentTooLarge = (0, _react.useMemo)(() => {
    var _values$length3;
    return !!displayValuesLimit && displayValuesLimit < ((_values$length3 = values === null || values === void 0 ? void 0 : values.length) !== null && _values$length3 !== void 0 ? _values$length3 : 0);
  }, [displayValuesLimit, values]);
  const renderValue = (0, _react.useCallback)((value, i) => /*#__PURE__*/_react.default.createElement("div", {
    key: `${i}-${value}`,
    "data-test-subj": `${value}-${_test_ids.HIGHLIGHTED_FIELDS_CELL_TEST_ID}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, showPreview && (0, _link_utils.isFlyoutLink)({
    field,
    scopeId
  }) ? /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
    field: field,
    value: value,
    scopeId: scopeId,
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_LINKED_CELL_TEST_ID,
    ancestorsIndexName: ancestorsIndexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }) : field === _constants.AGENT_STATUS_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
    agentId: String(value !== null && value !== void 0 ? value : ''),
    agentType: agentType,
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_AGENT_STATUS_CELL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_BASIC_CELL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, value)), [agentType, ancestorsIndexName, field, scopeId, showPreview]);
  if (values === null) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        div {
          margin-bottom: ${euiTheme.size.xs};
        }

        div:last-child {
          margin-bottom: 0;
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, visibleValues != null && visibleValues.map((value, i) => renderValue(value, i)), isContentExpanded && (overflownValues === null || overflownValues === void 0 ? void 0 : overflownValues.map(renderValue)), isContentTooLarge && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "both",
    onClick: toggleContentExpansion,
    "data-test-subj": "toggle-show-more-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, isContentExpanded ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.alertsHighlightedField.showMore",
    defaultMessage: "Show less",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.alertsHighlightedField.showLess",
    defaultMessage: "Show more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  })));
};
exports.HighlightedFieldsCell = HighlightedFieldsCell;