"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/graph_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Props for the GraphPreview component.
 */

const GraphLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/cloud-security-posture-graph'))).then(module => ({
  default: module.Graph
})));
const LoadingComponent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
  "data-test-subj": _test_ids.GRAPH_PREVIEW_LOADING_TEST_ID,
  contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.graphPreview.loadingAriaLabel', {
    defaultMessage: 'graph preview'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 3
  }
});

/**
 * Graph preview under Overview, Visualizations. It shows a graph without abilities to expand.
 */
const GraphPreview = exports.GraphPreview = /*#__PURE__*/(0, _react.memo)(({
  isLoading,
  isError,
  data
}) => {
  const memoizedNodes = (0, _react.useMemo)(() => {
    var _data$nodes;
    return (_data$nodes = data === null || data === void 0 ? void 0 : data.nodes) !== null && _data$nodes !== void 0 ? _data$nodes : [];
  }, [data === null || data === void 0 ? void 0 : data.nodes]);
  const memoizedEdges = (0, _react.useMemo)(() => {
    var _data$edges;
    return (_data$edges = data === null || data === void 0 ? void 0 : data.edges) !== null && _data$edges !== void 0 ? _data$edges : [];
  }, [data === null || data === void 0 ? void 0 : data.edges]);
  return isLoading ? /*#__PURE__*/_react.default.createElement(LoadingComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }) : isError || memoizedNodes.length === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.visualizations.graphPreview.errorDescription",
    defaultMessage: "An error is preventing this alert from being visualized.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(LoadingComponent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(GraphLazy, {
    css: (0, _react2.css)`
            height: 300px;
            width: 100%;
          `,
    nodes: memoizedNodes,
    edges: memoizedEdges,
    interactive: false,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.graphPreview.graphAriaLabel', {
      defaultMessage: 'Graph preview'
    }),
    "data-test-subj": _test_ids.GRAPH_PREVIEW_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }));
});
GraphPreview.displayName = 'GraphPreview';