"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAVED_TIMELINE_CALLOUT_CONTENT = exports.SAVE_TIMELINE_BUTTON = exports.SAVED_TIMELINE_CALLOUT_CONTENT = exports.AttachToActiveTimeline = exports.ATTACH_TO_TIMELINE_CHECKBOX = exports.ATTACH_TO_TIMELINE_CALLOUT_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _types = require("../../../../../common/types");
var _save_timeline_button = require("../../../../timelines/components/modal/actions/save_timeline_button");
var _test_ids = require("./test_ids");
var _store = require("../../../../timelines/store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/attach_to_active_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const timelineCheckBoxId = 'xpack.securitySolution.flyout.notes.attachToTimeline.checkboxId';
const ATTACH_TO_TIMELINE_CALLOUT_TITLE = exports.ATTACH_TO_TIMELINE_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.attachToTimeline.calloutTitle', {
  defaultMessage: 'Attach to current Timeline'
});
const SAVED_TIMELINE_CALLOUT_CONTENT = exports.SAVED_TIMELINE_CALLOUT_CONTENT = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.attachToTimeline.calloutContent', {
  defaultMessage: 'Also attach this note to the current Timeline.'
});
const UNSAVED_TIMELINE_CALLOUT_CONTENT = exports.UNSAVED_TIMELINE_CALLOUT_CONTENT = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.attachToTimeline.calloutContent', {
  defaultMessage: 'You must save the current Timeline before attaching notes to it.'
});
const ATTACH_TO_TIMELINE_CHECKBOX = exports.ATTACH_TO_TIMELINE_CHECKBOX = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.attachToTimeline.checkboxLabel', {
  defaultMessage: 'Attach to current Timeline'
});
const SAVE_TIMELINE_BUTTON = exports.SAVE_TIMELINE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.attachToTimeline.savedTimelineButtonLabel', {
  defaultMessage: 'Save current Timeline'
});
/**
 * Renders a callout and a checkbox to allow the user to attach a timeline id to a note.
 * If the active timeline is saved, the UI renders a checkbox to allow the user to attach the note to the timeline.
 * If the active timeline is not saved, the UI renders a button that allows the user to to save the timeline directly from the flyout.
 */
const AttachToActiveTimeline = exports.AttachToActiveTimeline = /*#__PURE__*/(0, _react.memo)(({
  setAttachToTimeline,
  isCheckboxDisabled
}) => {
  const [checked, setChecked] = (0, _react.useState)(true);
  const timeline = (0, _reactRedux.useSelector)(state => _store.timelineSelectors.selectTimelineById(state, _types.TimelineId.active));
  const isTimelineSaved = (0, _react.useMemo)(() => timeline.status === _timeline.TimelineStatusEnum.active, [timeline.status]);
  const onCheckboxChange = (0, _react.useCallback)(e => {
    setChecked(e.target.checked);
    setAttachToTimeline(e.target.checked);
  }, [setAttachToTimeline]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: ATTACH_TO_TIMELINE_CALLOUT_TITLE,
    color: isTimelineSaved ? 'primary' : 'warning',
    iconType: "info",
    "data-test-subj": _test_ids.ATTACH_TO_TIMELINE_CALLOUT_TEST_ID,
    css: (0, _react2.css)`
          margin-left: 50px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, isTimelineSaved ? SAVED_TIMELINE_CALLOUT_CONTENT : UNSAVED_TIMELINE_CALLOUT_CONTENT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, isTimelineSaved ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": _test_ids.ATTACH_TO_TIMELINE_CHECKBOX_TEST_ID,
    id: timelineCheckBoxId,
    label: ATTACH_TO_TIMELINE_CHECKBOX,
    disabled: isCheckboxDisabled,
    checked: checked,
    onChange: e => onCheckboxChange(e),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: _types.TimelineId.active,
    buttonText: SAVE_TIMELINE_BUTTON,
    buttonColor: "warning",
    "data-test-subj": _test_ids.SAVE_TIMELINE_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 15
    }
  }))));
});
AttachToActiveTimeline.displayName = 'AttachToActiveTimeline';