"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ID = exports.AuthenticationsQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _model = require("../../../../sourcerer/store/model");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _authentications_user_table = require("../../../components/authentication/authentications_user_table");
var _helpers = require("../../../components/authentication/helpers");
var _matrix_histogram = require("../../../../common/components/matrix_histogram");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/pages/navigation/authentications_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ID = exports.ID = 'usersAuthenticationsQuery';
const HISTOGRAM_QUERY_ID = 'usersAuthenticationsHistogramQuery';
const AuthenticationsQueryTabBody = ({
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type,
  deleteQuery,
  userName
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: endDate,
    filterQuery: filterQuery,
    id: HISTOGRAM_QUERY_ID,
    startDate: startDate
  }, _helpers.histogramConfigs, {
    sourcererScopeId: newDataViewPickerEnabled ? _model.SourcererScopeName.explore : _model.SourcererScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_authentications_user_table.AuthenticationsUserTable, {
    endDate: endDate,
    filterQuery: filterQuery,
    indexNames: indexNames,
    setQuery: setQuery,
    deleteQuery: deleteQuery,
    startDate: startDate,
    type: type,
    skip: skip,
    userName: userName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.AuthenticationsQueryTabBody = AuthenticationsQueryTabBody;
AuthenticationsQueryTabBody.displayName = 'AllUsersQueryTabBody';