"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.histogramConfigs = exports.DnsQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _network_dns_table = require("../../components/network_dns_table");
var _network_dns = require("../../containers/network_dns");
var _manage_query = require("../../../../common/components/page/manage_query");
var i18n = _interopRequireWildcard(require("./translations"));
var _matrix_histogram = require("../../../../common/components/matrix_histogram");
var _store = require("../../store");
var _use_selector = require("../../../../common/hooks/use_selector");
var _dns_top_domains = require("../../../../common/components/visualization_actions/lens_attributes/network/dns_top_domains");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _model = require("../../../../sourcerer/store/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/navigation/dns_query_tab_body.tsx",
  _dnsStackByOptions$fi;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HISTOGRAM_ID = 'networkDnsHistogramQuery';
const NetworkDnsTableManage = (0, _manage_query.manageQuery)(_network_dns_table.NetworkDnsTable);
const dnsStackByOptions = [{
  text: 'dns.question.registered_domain',
  value: 'dns.question.registered_domain'
}];
const DEFAULT_STACK_BY = 'dns.question.registered_domain';
const histogramConfigs = exports.histogramConfigs = {
  defaultStackByOption: (_dnsStackByOptions$fi = dnsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _dnsStackByOptions$fi !== void 0 ? _dnsStackByOptions$fi : dnsStackByOptions[0],
  stackByOptions: dnsStackByOptions,
  subtitle: undefined,
  getLensAttributes: _dns_top_domains.getDnsTopDomainsLensAttributes
};
const DnsQueryTabBodyComponent = ({
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  skip,
  startDate,
  setQuery,
  type
}) => {
  const getNetworkDnsSelector = _store.networkSelectors.dnsSelector();
  const isPtrIncluded = (0, _use_selector.useShallowEqualSelector)(state => getNetworkDnsSelector(state).isPtrIncluded);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: HISTOGRAM_ID
        });
      }
    };
  }, [deleteQuery]);
  const queryId = `${_network_dns.ID}-${type}`;
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    totalCount,
    networkDns,
    pageInfo,
    loadPage,
    id,
    inspect,
    isInspected,
    refetch
  }] = (0, _network_dns.useNetworkDns)({
    endDate,
    filterQuery,
    id: queryId,
    indexNames,
    skip: querySkip,
    startDate
  });
  const getTitle = (0, _react.useCallback)(option => i18n.DOMAINS_COUNT_BY(option.text), []);
  const dnsHistogramConfigs = (0, _react.useMemo)(() => ({
    ...histogramConfigs,
    title: getTitle
  }), [getTitle]);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    id: HISTOGRAM_ID,
    isPtrIncluded: isPtrIncluded,
    endDate: endDate,
    filterQuery: filterQuery,
    startDate: startDate
  }, dnsHistogramConfigs, {
    sourcererScopeId: newDataViewPickerEnabled ? _model.SourcererScopeName.explore : _model.SourcererScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(NetworkDnsTableManage, {
    data: networkDns,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: totalCount,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }));
};
DnsQueryTabBodyComponent.displayName = 'DnsQueryTabBodyComponent';
const DnsQueryTabBody = exports.DnsQueryTabBody = /*#__PURE__*/_react.default.memo(DnsQueryTabBodyComponent);