"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringSampleDashboard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _header_section = require("../../../../../common/components/header_section");
var _get_lens_attributes = require("./get_lens_attributes");
var _use_columns = require("./use_columns");
var _constants = require("./constants");
var _esql_data_generation = require("./esql_data_generation");
var _esql_dashboard_panel = require("../esql_dashboard_panel/esql_dashboard_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/sample_dashboard/sample_dashboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedUserMonitoringSampleDashboardComponent = () => {
  const columns = (0, _use_columns.useColumns)();
  const esqlSource = (0, _react.useMemo)(() => (0, _esql_data_generation.generateESQLSource)(), []); // It needs to be memoized to avoid re-generating source data on every render
  const bucketTimerange = (0, _react.useMemo)(() => (0, _esql_data_generation.getBucketTimeRange)(), []);
  const generateTableQuery = (0, _react.useMemo)(() => (0, _esql_data_generation.generateListESQLQuery)(esqlSource), [esqlSource]);
  const generateVisualizationQuery = (0, _react.useMemo)(() => (0, _esql_data_generation.generateVisualizationESQLQuery)(esqlSource), [esqlSource]);
  const stackByOptions = _constants.GRANTED_RIGHTS_STACK_BY_OPTIONS;
  const setSelectedChartOptionCallback = (0, _react.useCallback)(value => {
    setSelectedStackByOption(value !== null && value !== void 0 ? value : stackByOptions[0].value);
  }, [stackByOptions]);
  const defaultStackByOption = stackByOptions[0];
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(defaultStackByOption.value);
  const stackByLabel = _i18n.i18n.translate('xpack.securitySolution.genericDashboard.stackBy.label', {
    defaultMessage: 'Stack by'
  });
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.sampleDashboard.grantedRights.title",
    defaultMessage: "Granted rights",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "privMonSampleDashboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: title,
    titleSize: "s",
    outerDirection: 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    onChange: setSelectedChartOptionCallback,
    options: _constants.GRANTED_RIGHTS_STACK_BY_OPTIONS,
    prepend: stackByLabel,
    "aria-label": stackByLabel,
    valueOfSelected: selectedStackByOption,
    hasDividers: true,
    itemLayoutAlign: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_esql_dashboard_panel.EsqlDashboardPanel, {
    title: title,
    timerange: bucketTimerange,
    stackByField: selectedStackByOption,
    getLensAttributes: _get_lens_attributes.getLensAttributes,
    generateVisualizationQuery: generateVisualizationQuery,
    generateTableQuery: generateTableQuery,
    columns: columns,
    pageSize: _constants.PAGE_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
};
const PrivilegedUserMonitoringSampleDashboard = exports.PrivilegedUserMonitoringSampleDashboard = /*#__PURE__*/_react.default.memo(PrivilegedUserMonitoringSampleDashboardComponent);