"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoring = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _risk_level_panel = require("./components/risk_level_panel");
var _key_insights_panel = require("./components/key_insights_panel");
var _privileged_user_activity = require("./components/privileged_user_activity");
var _privileged_access_detection = require("./components/privileged_access_detection");
var _privileged_users_table = require("./components/privileged_users_table");
var _missing_privileges_callout = require("../missing_privileges_callout");
var _use_privileged_monitoring_privileges = require("../../api/hooks/use_privileged_monitoring_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedUserMonitoring = ({
  callout,
  error,
  onManageUserClicked,
  sourcererDataView
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const [dismissCallout, setDismissCallout] = (0, _react.useState)(false);
  const handleDismiss = (0, _react.useCallback)(() => {
    setDismissCallout(true);
  }, []);
  const {
    data: privileges
  } = (0, _use_privileged_monitoring_privileges.usePrivilegedMonitoringPrivileges)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, !privileges || privileges.has_all_required ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallout, {
    privileges: privileges,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboard.missingPrivileges.title",
      defaultMessage: "Insufficient privileges to view the privileged user monitoring panels",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, error && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboard.errorTitle",
      defaultMessage: "Error loading privileged user monitoring data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "cross",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, error)), callout && !dismissCallout && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "privilegedUserMonitoringOnboardingCallout",
    title: callout.userCount > 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboard.userCountCallout.title",
      defaultMessage: "Privileged user monitoring set up: {userCount, plural, one {# user added} other {# users added}}",
      values: {
        userCount: callout.userCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboard.noUserCallout.Title",
      defaultMessage: "Privileged user monitoring set up",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }),
    color: "success",
    iconType: "check",
    onDismiss: handleDismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboard.callout.description",
    defaultMessage: 'Your data source has been added. You can now start monitoring privileged user activity to detect potential threats before they escalate or cause damage. You can always update your list of privileged users from the data source settings.',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "gear",
    color: "success",
    fill: true,
    size: "s",
    onClick: onManageUserClicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.dashboard.callout.manageDataSources",
    defaultMessage: "Manage data sources",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, spaceId && /*#__PURE__*/_react.default.createElement(_risk_level_panel.RiskLevelsPrivilegedUsersPanel, {
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, spaceId && /*#__PURE__*/_react.default.createElement(_key_insights_panel.KeyInsightsPanel, {
    spaceId: spaceId,
    sourcerDataView: sourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 25
    }
  })))), spaceId && /*#__PURE__*/_react.default.createElement(_privileged_users_table.PrivilegedUsersTable, {
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 19
    }
  }), spaceId && /*#__PURE__*/_react.default.createElement(_privileged_access_detection.PrivilegedAccessDetectionsPanel, {
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_privileged_user_activity.UserActivityPrivilegedUsersPanel, {
    sourcererDataView: sourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  })));
};
exports.PrivilegedUserMonitoring = PrivilegedUserMonitoring;