"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_enabled_entity_types = require("../../../../hooks/use_enabled_entity_types");
var _use_error_toast = require("../../../../../common/hooks/use_error_toast");
var _download_blob = require("../../../../../common/utils/download_blob");
var _engine_components_status = require("./components/engine_components_status");
var _use_entity_store = require("../../hooks/use_entity_store");
var _helpers = require("./helpers");
var _engine_status_header = require("./components/engine_status_header");
var _engine_status_header_action = require("./components/engine_status_header_action");
var _entity_store_error_callout = require("../entity_store_error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/engines_status/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FILE_NAME = 'engines_status.json';
const errorMessage = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.queryError', {
  defaultMessage: 'There was an error loading the engine status'
});
const EngineStatus = () => {
  var _data$engines;
  const {
    data,
    isLoading: isStatusAPILoading,
    error
  } = (0, _use_entity_store.useEntityStoreStatus)({
    withComponents: true
  });
  const enabledEntityTypes = (0, _use_enabled_entity_types.useEntityStoreTypes)();
  const downloadJson = () => {
    (0, _download_blob.downloadBlob)(new Blob([JSON.stringify(data)]), FILE_NAME);
  };
  (0, _use_error_toast.useErrorToast)(errorMessage, error);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: errorMessage,
      color: "danger",
      iconType: "alert",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  }
  if (!data || isStatusAPILoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 43
    }
  });
  if (data.engines.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.notFoundMessage",
      defaultMessage: "No engines found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    });
  }
  const enginesStatusData = enabledEntityTypes.map(type => ({
    type,
    engine: data.engines.find(e => e.type === type)
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, (data === null || data === void 0 ? void 0 : (_data$engines = data.engines) === null || _data$engines === void 0 ? void 0 : _data$engines.length) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: downloadJson,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.downloadButton",
    defaultMessage: "Download status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, enginesStatusData.map(({
    engine,
    type
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_engine_status_header.EngineStatusHeader, {
      entityType: type,
      actionButton: /*#__PURE__*/_react.default.createElement(_engine_status_header_action.EngineStatusHeaderAction, {
        engine: engine,
        type: type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 31
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_entity_store_error_callout.EntityStoreErrorCallout, {
      engine: engine,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 15
      }
    }, engine && !(0, _helpers.isEngineLoading)(engine.status) && engine.components && /*#__PURE__*/_react.default.createElement(_engine_components_status.EngineComponentsStatusTable, {
      components: engine.components,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    }));
  })));
};
exports.EngineStatus = EngineStatus;