"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityResultStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _links = require("../../../../common/components/links");
var _helpers = require("../helpers");
var _schedule_risk_engine_callout = require("./schedule_risk_engine_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/asset_criticality_file_uploader/components/result_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AssetCriticalityResultStep = exports.AssetCriticalityResultStep = /*#__PURE__*/_react.default.memo(({
  result,
  validLinesAsText,
  errorMessage,
  onReturn
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (errorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "asset-criticality-result-step-error",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Asset criticality assignment failed.",
        id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.errorMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 13
        }
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, errorMessage), /*#__PURE__*/_react.default.createElement(ResultStepFooter, {
      onReturn: onReturn,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }));
  }
  if (result === undefined) {
    return null;
  }
  if (result.stats.failed === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "asset-criticality-result-step-success",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Success",
        id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.successTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 13
        }
      }),
      color: "success",
      iconType: "checkInCircleFilled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Your asset criticality levels have been assigned. Note that your assignments can take a few moments to populate.",
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.successMessage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      deepLinkId: _deeplinksSecurity.SecurityPageName.entityAnalytics,
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "View asset criticality assignments.",
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.viewAssetCriticalityAssignments",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_schedule_risk_engine_callout.ScheduleRiskEngineCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(ResultStepFooter, {
      onReturn: onReturn,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }));
  }
  const annotations = (0, _helpers.buildAnnotationsFromError)(result.errors);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "asset-criticality-result-step-warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Some asset criticality assignments were unsuccessful due to errors.",
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.partialError.title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{assignedCount, plural, one {# asset criticality assignment succeeded.} other {# asset criticality assignments succeeded.}}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.partialError.assignedEntities",
    values: {
      assignedCount: result.stats.successful
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{failedCount, plural, one {# asset criticality assignment failed.} other {# asset criticality assignments failed.}}",
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.partialError.failedEntities",
    values: {
      failedCount: result.stats.failed
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 400,
    language: "CSV",
    isVirtualized: true,
    css: (0, _react2.css)`
            border: 1px solid ${euiTheme.colors.warning};
          `,
    lineNumbers: {
      annotations
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, validLinesAsText)), /*#__PURE__*/_react.default.createElement(ResultStepFooter, {
    onReturn: onReturn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }));
});
AssetCriticalityResultStep.displayName = 'AssetCriticalityResultStep';
const ResultStepFooter = ({
  onReturn
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xl",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 146,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 147,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "flexEnd",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 148,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onReturn,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 149,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  defaultMessage: "Upload another file",
  id: "xpack.securitySolution.entityAnalytics.assetCriticalityResultStep.uploadAnotherFile",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 150,
    columnNumber: 9
  }
}))));