"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.SKELETON_TEST_ID = exports.DATA_VIEW_LOADING_PROMPT_TEST_ID = exports.DATA_VIEW_ERROR_TEST_ID = exports.CONTENT_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_create_data_view = require("../../hooks/alert_summary/use_create_data_view");
var _kpis_section = require("./kpis/kpis_section");
var _integration_section = require("./integrations/integration_section");
var _search_bar_section = require("./search_bar/search_bar_section");
var _table_section = require("./table/table_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATAVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.alertSummary.dataViewError', {
  defaultMessage: 'Unable to create data view'
});
const DATA_VIEW_LOADING_PROMPT_TEST_ID = exports.DATA_VIEW_LOADING_PROMPT_TEST_ID = 'alert-summary-data-view-loading-prompt';
const DATA_VIEW_ERROR_TEST_ID = exports.DATA_VIEW_ERROR_TEST_ID = 'alert-summary-data-view-error';
const SKELETON_TEST_ID = exports.SKELETON_TEST_ID = 'alert-summary-skeleton';
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'alert-summary-content';
/**
 * Creates a new adhoc dataView for the alert summary page. The dataView is created just with the alert indices.
 * During the creating, we display a loading skeleton, mimicking the future alert summary page content.
 * Once the dataView is correctly created, we render the content.
 * If the creation fails, we show an error message.
 */
const Wrapper = exports.Wrapper = /*#__PURE__*/(0, _react.memo)(({
  packages
}) => {
  const {
    dataView,
    loading
  } = (0, _use_create_data_view.useCreateEaseAlertsDataView)();
  const signalIndexName = (0, _react.useMemo)(() => dataView ? dataView.getIndexPattern() : '', [dataView]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    "data-test-subj": DATA_VIEW_LOADING_PROMPT_TEST_ID,
    isLoading: loading,
    loadingContent: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": SKELETON_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 50,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 50,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 275,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: 600,
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    })),
    loadedContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !dataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "danger",
      "data-test-subj": DATA_VIEW_ERROR_TEST_ID,
      iconType: "error",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 22
        }
      }, DATAVIEW_ERROR),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": CONTENT_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_integration_section.IntegrationSection, {
      packages: packages,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_search_bar_section.SearchBarSection, {
      dataView: dataView,
      packages: packages,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_kpis_section.KPIsSection, {
      signalIndexName: signalIndexName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_table_section.TableSection, {
      dataView: dataView,
      packages: packages,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
});
Wrapper.displayName = 'Wrapper';