"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.getIntegrationComponent = exports.TABLE_GROUP_STATS_TEST_ID = exports.IntegrationIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _integration_icon = require("../common/integration_icon");
var _table_section_context = require("./table_section_context");
var _grouping_settings = require("../../alerts_table/grouping_settings");
var _alerts_grouping = require("../../alerts_table/alerts_grouping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/group_stats_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const STATS_GROUP_SIGNAL_RULE_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummary.groups.integrations', {
  defaultMessage: 'Integrations:'
});
const STATS_GROUP_SIGNAL_RULE_ID_MULTI = _i18n.i18n.translate('xpack.securitySolution.alertSummary.groups.integrations.multi', {
  defaultMessage: ' Multi'
});
const TABLE_GROUP_STATS_TEST_ID = exports.TABLE_GROUP_STATS_TEST_ID = 'ai-for-soc-alert-table-group-stats';
/**
 * Renders the icon for the integration that matches the integration name.
 * In AI for SOC, we can retrieve the integration/package via the kibana.rule.parameters field on the alert.
 */
const IntegrationIcon = exports.IntegrationIcon = /*#__PURE__*/(0, _react.memo)(({
  integrationName
}) => {
  const {
    packages
  } = (0, _table_section_context.useTableSectionContext)();
  const integration = packages.find(p => integrationName === p.name);
  return /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": TABLE_GROUP_STATS_TEST_ID,
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 10
    }
  });
});
IntegrationIcon.displayName = 'IntegrationIcon';

/**
 * Return a renderer for integration aggregation.
 */
const getIntegrationComponent = bucket => {
  var _bucket$relatedIntegr;
  const integrationNames = (_bucket$relatedIntegr = bucket.relatedIntegrationSubAggregation) === null || _bucket$relatedIntegr === void 0 ? void 0 : _bucket$relatedIntegr.buckets;
  if (!integrationNames || integrationNames.length === 0) {
    return [];
  }
  if (integrationNames.length === 1) {
    const integrationName = Array.isArray(integrationNames[0].key) ? integrationNames[0].key[0] : integrationNames[0].key;
    return [{
      title: STATS_GROUP_SIGNAL_RULE_ID,
      component: /*#__PURE__*/_react.default.createElement(IntegrationIcon, {
        integrationName: integrationName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 20
        }
      })
    }];
  }
  return [{
    title: STATS_GROUP_SIGNAL_RULE_ID,
    component: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, STATS_GROUP_SIGNAL_RULE_ID_MULTI)
  }];
};

/**
 * Returns stats to be used in the`extraAction` property of the EuiAccordion component used within the kbn-grouping package.
 * It handles custom renders for the following fields:
 * - relatedIntegration (a runTime field we're creating and using in the adhoc dataView)
 * - kibana.alert.severity
 * - kibana.alert.rule.name
 * And returns a default view for all the other fields.
 *
 * These go hand in hand with groupingOptions, groupTitleRenderers and groupStatsAggregations.
 */
exports.getIntegrationComponent = getIntegrationComponent;
const groupStatsRenderer = (selectedGroup, bucket) => {
  const defaultBadges = (0, _alerts_grouping.DEFAULT_GROUP_STATS_RENDERER)(selectedGroup, bucket);
  const severityComponent = (0, _grouping_settings.getSeverityComponent)(bucket);
  const integrationComponent = getIntegrationComponent(bucket);
  const rulesBadge = (0, _grouping_settings.getRulesBadge)(bucket);
  switch (selectedGroup) {
    case _constants.RELATED_INTEGRATION:
      return [...severityComponent, rulesBadge, ...defaultBadges];
    case 'kibana.alert.severity':
      return [...integrationComponent, rulesBadge, ...defaultBadges];
    case 'kibana.alert.rule.name':
      return [...integrationComponent, ...severityComponent, ...defaultBadges];
    default:
      return [...integrationComponent, ...severityComponent, rulesBadge, ...defaultBadges];
  }
};
exports.groupStatsRenderer = groupStatsRenderer;