"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBarSection = exports.SEARCH_BAR_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_integrations = require("../../../hooks/alert_summary/use_integrations");
var _search_bar = require("../../../../common/components/search_bar");
var _integrations_filter_button = require("./integrations_filter_button");
var _constants = require("../../../../common/store/inputs/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/search_bar/search_bar_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_BAR_TEST_ID = exports.SEARCH_BAR_TEST_ID = 'alert-summary-search-bar';
/**
 * KQL bar at the top of the alert summary page.
 * The component leverages the Security Solution SiemSearchBar which has a lot of logic tied to url and redux to store its values.
 * The component also has a filter button to the left of the KQL bar that allows user to select integrations.
 */
const SearchBarSection = exports.SearchBarSection = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  packages
}) => {
  const {
    integrations
  } = (0, _use_integrations.useIntegrations)({
    packages
  });
  const dataViewSpec = (0, _react.useMemo)(() => dataView.toSpec(), [dataView]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_integrations_filter_button.IntegrationFilterButton, {
    integrations: integrations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    dataTestSubj: SEARCH_BAR_TEST_ID,
    hideFilterBar: true,
    hideQueryMenu: true,
    id: _constants.InputsModelId.global,
    sourcererDataView: dataViewSpec,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })));
});
SearchBarSection.displayName = 'SearchBarSection';