"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_RULES_WITH_CONFLICTS = exports.UPGRADE_RULES_WITHOUT_CONFLICTS = exports.UPGRADE_CONFLICTS_MODAL_TITLE = exports.UPGRADE_CONFLICTS_MODAL_CANCEL = exports.RULES_WITH_SOLVABLE_CONFLICTS_TOTAL = exports.RULES_WITH_NON_SOLVABLE_CONFLICTS_TOTAL = exports.RULES_WITH_NON_SOLVABLE_CONFLICTS_GUIDANCE = exports.RULES_WITH_AUTO_RESOLVED_CONFLICTS_GUIDANCE = exports.RULES_WITHOUT_CONFLICTS_TOTAL = exports.RULES_WITHOUT_CONFLICTS_GUIDANCE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_upgrade_with_conflicts_modal/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UPGRADE_CONFLICTS_MODAL_TITLE = exports.UPGRADE_CONFLICTS_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeConflictsModal.messageTitle', {
  defaultMessage: 'Conflicts found'
});
const UPGRADE_CONFLICTS_MODAL_CANCEL = exports.UPGRADE_CONFLICTS_MODAL_CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeConflictsModal.cancelTitle', {
  defaultMessage: 'Cancel'
});
const UPGRADE_RULES_WITHOUT_CONFLICTS = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeConflictsModal.upgradeRulesWithoutConflicts', {
  defaultMessage: 'Update {rulesCount, plural, =1 {rule} other {rules}} without conflicts',
  values: {
    rulesCount
  }
});
exports.UPGRADE_RULES_WITHOUT_CONFLICTS = UPGRADE_RULES_WITHOUT_CONFLICTS;
const UPGRADE_RULES_WITH_CONFLICTS = numOfRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeConflictsModal.upgradeRulesWithConflicts', {
  defaultMessage: 'Update {numOfRules, plural, =1 {rule} other {rules}}',
  values: {
    numOfRules
  }
});
exports.UPGRADE_RULES_WITH_CONFLICTS = UPGRADE_RULES_WITH_CONFLICTS;
const RULES_WITH_NON_SOLVABLE_CONFLICTS_TOTAL = numOfRulesWithNonSolvableConflicts => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.rulesWithNonSolvableConflictsTotal",
  defaultMessage: "Rules with unresolved conflicts: {numOfRulesWithNonSolvableConflictsStrong}",
  values: {
    numOfRulesWithNonSolvableConflictsStrong: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, numOfRulesWithNonSolvableConflicts)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 3
  }
});
exports.RULES_WITH_NON_SOLVABLE_CONFLICTS_TOTAL = RULES_WITH_NON_SOLVABLE_CONFLICTS_TOTAL;
const RULES_WITH_SOLVABLE_CONFLICTS_TOTAL = numOfRulesWithSolvableConflicts => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.rulesWithSolvableConflictsTotal",
  defaultMessage: "Rules with auto-resolved conflicts: {numOfRulesWithSolvableConflictsStrong}",
  values: {
    numOfRulesWithSolvableConflictsStrong: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 46
      }
    }, numOfRulesWithSolvableConflicts)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 3
  }
});
exports.RULES_WITH_SOLVABLE_CONFLICTS_TOTAL = RULES_WITH_SOLVABLE_CONFLICTS_TOTAL;
const RULES_WITHOUT_CONFLICTS_TOTAL = numOfRulesWithoutConflicts => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.rulesWithoutConflictsTotal",
  defaultMessage: "Rules without conflicts: {numOfRulesWithoutConflictsStrong}",
  values: {
    numOfRulesWithoutConflictsStrong: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 41
      }
    }, numOfRulesWithoutConflicts)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 3
  }
});
exports.RULES_WITHOUT_CONFLICTS_TOTAL = RULES_WITHOUT_CONFLICTS_TOTAL;
const RULES_WITH_NON_SOLVABLE_CONFLICTS_GUIDANCE = numOfRulesWithNonSolvableConflicts => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.rulesWithNonSolvableConflictsGuidance",
  defaultMessage: "{numOfRulesWithNonSolvableConflictsStrong} {numOfRulesWithNonSolvableConflicts, plural, =1 {rule} other {rules}} with unresolved {numOfRulesWithNonSolvableConflicts, plural, =1 {conflict} other {conflicts}} can\u2019t be updated until you fix the {numOfRulesWithNonSolvableConflicts, plural, =1 {conflict} other {conflicts}}.",
  values: {
    numOfRulesWithNonSolvableConflicts,
    numOfRulesWithNonSolvableConflictsStrong: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, numOfRulesWithNonSolvableConflicts)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 3
  }
});
exports.RULES_WITH_NON_SOLVABLE_CONFLICTS_GUIDANCE = RULES_WITH_NON_SOLVABLE_CONFLICTS_GUIDANCE;
const ACCEPT_SOLVABLE_CONFLICTS_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeConflictsModal.acceptSolvableConflictsWarning', {
  defaultMessage: 'Only choose this option if you’re comfortable accepting the fixes Elastic suggested.'
});
const RULES_WITH_AUTO_RESOLVED_CONFLICTS_GUIDANCE = ({
  numOfRulesWithSolvableConflicts,
  numOfRulesWithoutConflicts
}) => {
  const docsUrl = (0, _kibana.useKibana)().services.docLinks.links.securitySolution.resolvePrebuiltRuleConflicts;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.rulesWithAutoResolvedConflictsGuidance",
    defaultMessage: "{numOfRulesWithSolvableConflictsStrong} {numOfRulesWithSolvableConflicts, plural, =1 {rule} other {rules}} with auto-resolved {numOfRulesWithSolvableConflicts, plural, =1 {conflict} other {conflicts}} can still be updated. Choose one of the following options:",
    values: {
      numOfRulesWithSolvableConflicts,
      numOfRulesWithSolvableConflictsStrong: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, numOfRulesWithSolvableConflicts)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.useRuleUpdateFlyout",
    defaultMessage: "Use the rule update flyout to address auto-resolved conflicts. This is the safest option and gives you more control over the final update. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsUrl,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.learnMore",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.bulkUpdateRules",
    defaultMessage: "Click {updateRules} to bulk-update rules with auto-resolved conflicts and rules without conflicts.",
    values: {
      updateRules: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 19
        }
      }, UPGRADE_RULES_WITH_CONFLICTS(numOfRulesWithSolvableConflicts + numOfRulesWithoutConflicts))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: ACCEPT_SOLVABLE_CONFLICTS_WARNING,
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }));
};
exports.RULES_WITH_AUTO_RESOLVED_CONFLICTS_GUIDANCE = RULES_WITH_AUTO_RESOLVED_CONFLICTS_GUIDANCE;
const RULES_WITHOUT_CONFLICTS_GUIDANCE = numOfRulesWithoutConflicts => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.upgradeConflictsModal.rulesWithoutConflictsGuidance",
  defaultMessage: "{numOfRulesWithoutConflictsStrong} {numOfRulesWithoutConflicts, plural, =1 {rule} other {rules}} without conflicts can still be updated by clicking {updateRulesWithoutConflicts}. Choose this option if you only want to update {numOfRulesWithoutConflicts, plural, =1 {the rule} other {rules}} without conflicts.",
  values: {
    numOfRulesWithoutConflicts,
    numOfRulesWithoutConflictsStrong: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 41
      }
    }, numOfRulesWithoutConflicts),
    updateRulesWithoutConflicts: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 9
      }
    }, UPGRADE_RULES_WITHOUT_CONFLICTS(numOfRulesWithoutConflicts))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 170,
    columnNumber: 3
  }
});
exports.RULES_WITHOUT_CONFLICTS_GUIDANCE = RULES_WITHOUT_CONFLICTS_GUIDANCE;